/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CheckDependencyStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "checkDependency";
    private InstalledComponentTargeter mTargeter;

    private CheckDependencyStep() {
    }

    public CheckDependencyStep(Element checkDependencyElement) {
        super(checkDependencyElement);
        this.setTargeter(ComponentTargeterFactory.getInstalledTargeter(checkDependencyElement));
    }

    public CheckDependencyStep(InstalledComponentTargeter targeter) {
        this.setTargeter(targeter);
    }

    public InstalledComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(InstalledComponentTargeter targeter) {
        if (targeter == null) {
            throw new NullPointerException();
        }
        this.mTargeter = targeter;
    }

    protected void populateXML(XML outXML) {
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CheckDependencyStep)) {
            return false;
        }
        CheckDependencyStep theStep = (CheckDependencyStep)inStep;
        return this.equals(theStep.getTargeter(), this.getTargeter());
    }

    public int getStepType() {
        return 114;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        CheckDependencyStep copy = (CheckDependencyStep)super.generate(generator);
        copy.setTargeter((InstalledComponentTargeter)copy.mTargeter.generate(generator));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        CheckDependencyStep result = (CheckDependencyStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        return result;
    }
}

