/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotCaptureStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CaptureSnapshotStep
extends ExecStep
implements SnapshotCaptureStep,
AggregateStep {
    public static final String ELEMENT_NAME = "addSnapshot";
    private static final String ATTR_BLOCK_NAME = "blockName";
    private String mBlockName;
    private ArgList mArgs;
    private InstalledComponentTargeter mTargeter;

    private CaptureSnapshotStep() {
    }

    public CaptureSnapshotStep(Element stepElement) throws SystemModelParseException {
        super(stepElement);
        this.setBlockName(CaptureSnapshotStep.getAttribute(stepElement, ATTR_BLOCK_NAME));
        this.setArgs(new ArgList(stepElement));
        this.setTargeter(ComponentTargeterFactory.getInstalledTargeter(stepElement));
    }

    public CaptureSnapshotStep(String blockName, InstalledComponentTargeter targetComp, VariableSettingsSource args) {
        this.setBlockName(blockName);
        this.setTargeter(targetComp);
        this.setArgs(args);
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    private void setBlockName(String blockName) {
        this.mBlockName = blockName;
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        if (args == null) {
            this.setArgs(new ArgList());
        } else {
            this.setArgs(new ArgList(args));
        }
    }

    private void setArgs(ArgList args) {
        this.mArgs = args;
    }

    public InstalledComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(InstalledComponentTargeter targeter) {
        if (targeter == null) {
            targeter = new ThisTargeter();
        }
        this.mTargeter = targeter;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        CaptureSnapshotStep result = (CaptureSnapshotStep)super.generate(generator);
        result.setTargeter((InstalledComponentTargeter)this.mTargeter.generate(generator));
        result.setArgs(this.mArgs.generate(generator));
        return result;
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    protected void populateXML(XML outXML) {
        CaptureSnapshotStep.addAttributeIfNotNull(outXML, ATTR_BLOCK_NAME, this.getBlockName());
        this.mArgs.writeToXML(outXML);
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CaptureSnapshotStep)) {
            return false;
        }
        CaptureSnapshotStep theStep = (CaptureSnapshotStep)inStep;
        return ObjectUtil.equals(this.getBlockName(), theStep.getBlockName()) && ObjectUtil.equals(this.getTargeter(), theStep.getTargeter()) && ObjectUtil.equals(this.mArgs, theStep.mArgs);
    }

    public int getStepType() {
        return 122;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
        v.visit(this.mArgs);
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        CaptureSnapshotStep result = (CaptureSnapshotStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }
}

