/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotCaptureStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotFilter;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotOwnership;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CaptureFileStep
extends ExecStep
implements SnapshotCaptureStep {
    public static final String ELEMENT_NAME = "addFile";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_OWNERSHIP = "ownership";
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_RECURSE = "recursive";
    private static final String ATTR_DISPLAY_NAME = "displayName";
    private static final SnapshotOwnership DEFAULT_OWNERSHIP = SnapshotOwnership.SET_SELF;
    private static final SnapshotFilter DEFAULT_FILTER = SnapshotFilter.BOTH;
    private static final boolean DEFAULT_RECURSE = true;
    private String mPath;
    private SnapshotOwnership mOwnership;
    private SnapshotFilter mFilter;
    private boolean mIsRecursive;
    private String mDisplayName;

    private CaptureFileStep() {
    }

    public CaptureFileStep(Element stepElement) {
        super(stepElement);
        this.setPath(CaptureFileStep.getAttribute(stepElement, ATTR_PATH));
        SnapshotOwnership owner = (SnapshotOwnership)CaptureFileStep.getEnumAttribute(stepElement, ATTR_OWNERSHIP, SnapshotOwnership.FACTORY);
        this.setOwnership(owner);
        SnapshotFilter filter = (SnapshotFilter)CaptureFileStep.getEnumAttribute(stepElement, ATTR_FILTER, SnapshotFilter.FACTORY);
        this.setFilter(filter);
        this.setIsRecursive(CaptureFileStep.getBooleanAttribute(stepElement, ATTR_RECURSE));
        this.setDisplayName(CaptureFileStep.getAttribute(stepElement, ATTR_DISPLAY_NAME));
    }

    public CaptureFileStep(String path, SnapshotOwnership ownership, SnapshotFilter filter, Boolean isRecursive, String displayName) {
        this.setPath(path);
        this.setOwnership(ownership);
        this.setFilter(filter);
        this.setIsRecursive(isRecursive);
        this.setDisplayName(displayName);
    }

    public String getPath() {
        return this.mPath;
    }

    private void setPath(String path) {
        this.mPath = path;
    }

    public SnapshotOwnership getOwnership() {
        return this.mOwnership;
    }

    private void setOwnership(SnapshotOwnership ownership) {
        if (ownership == null) {
            ownership = DEFAULT_OWNERSHIP;
        }
        this.mOwnership = ownership;
    }

    public SnapshotFilter getFilter() {
        return this.mFilter;
    }

    private void setFilter(SnapshotFilter filter) {
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        this.mFilter = filter;
    }

    public boolean getIsRecursive() {
        return this.mIsRecursive;
    }

    private void setIsRecursive(Boolean isRecursive) {
        this.mIsRecursive = isRecursive == null ? true : isRecursive;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    private void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        CaptureFileStep result = (CaptureFileStep)super.generate(generator);
        result.setPath(generator.generate(result.getPath()));
        result.setDisplayName(generator.generate(result.getDisplayName()));
        return result;
    }

    protected void populateXML(XML outXML) {
        CaptureFileStep.addAttributeIfNotNull(outXML, ATTR_PATH, this.getPath());
        if (!DEFAULT_OWNERSHIP.equals(this.getOwnership())) {
            CaptureFileStep.addAttributeIfNotNull(outXML, ATTR_OWNERSHIP, this.getOwnership().toString());
        }
        if (!DEFAULT_FILTER.equals(this.getFilter())) {
            CaptureFileStep.addAttributeIfNotNull(outXML, ATTR_FILTER, this.getFilter().toString());
        }
        if (!this.getIsRecursive()) {
            CaptureFileStep.addAttributeIfNotNull(outXML, ATTR_RECURSE, String.valueOf(this.getIsRecursive()));
        }
        CaptureFileStep.addAttributeIfNotNull(outXML, ATTR_DISPLAY_NAME, this.getDisplayName());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CaptureFileStep)) {
            return false;
        }
        CaptureFileStep theStep = (CaptureFileStep)inStep;
        return ObjectUtil.equals(this.getPath(), theStep.getPath()) && ObjectUtil.equals(this.getOwnership(), theStep.getOwnership()) && ObjectUtil.equals(this.getFilter(), theStep.getFilter()) && this.getIsRecursive() == theStep.getIsRecursive() && ObjectUtil.equals(this.getDisplayName(), theStep.getDisplayName());
    }

    public int getStepType() {
        return 118;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getPath());
        v.visitToken(this.getDisplayName());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        CaptureFileStep result = (CaptureFileStep)super.accept(t);
        result.setPath(t.transformToken(this.getPath()));
        result.setDisplayName(t.transformToken(this.getDisplayName()));
        return result;
    }
}

