/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;

public class Caller {
    private InstalledComponent mInstalledComponent = null;
    private Component mActualComponent = null;
    private Component mDeclaredComponent = null;
    private FolderID mDeclaredPath;
    private FolderID mActualPath = null;
    private String mDeclaredName;

    public Caller(InstalledComponent instComp, Component actual) {
        this(instComp, actual, actual);
    }

    public Caller(InstalledComponent instComp, Component actual, Component declared) {
        this.setInstalledComponent(instComp);
        this.setActualComponent(actual);
        this.setActualPath(actual.getPath());
        if (declared == null) {
            declared = actual;
        }
        this.setDeclaredComponent(declared);
        this.setDeclaredPath(declared.getPath());
        this.setDeclaredName(declared.getName());
    }

    Caller(SummaryExecutionPlan plan) {
        this.setDeclaredPath(plan.getPath());
        this.setActualPath(plan.getPath());
        this.setDeclaredName(plan.getName());
    }

    public InstalledComponent getInstalledComponent() {
        return this.mInstalledComponent;
    }

    private void setInstalledComponent(InstalledComponent installedComponent) {
        this.mInstalledComponent = installedComponent;
    }

    public Component getActualComponent() {
        return this.mActualComponent;
    }

    private void setActualComponent(Component actual) {
        this.mActualComponent = actual;
    }

    public Component getDeclaredComponent() {
        return this.mDeclaredComponent;
    }

    private void setDeclaredComponent(Component comp) {
        this.mDeclaredComponent = comp;
    }

    public FolderID getDeclaredPath() {
        return this.mDeclaredPath;
    }

    private void setDeclaredPath(FolderID path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.mDeclaredPath = path;
    }

    public FolderID getActualPath() {
        return this.mActualPath;
    }

    private void setActualPath(FolderID inActualPath) {
        this.mActualPath = inActualPath;
    }

    public String getDeclaredName() {
        return this.mDeclaredName;
    }

    private void setDeclaredName(String name) {
        this.mDeclaredName = name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{actual:").append(this.getActualComponent() == null ? "null" : this.getActualComponent().getName()).append(",");
        buf.append("declared:").append(this.getDeclaredComponent() == null ? "null" : this.getDeclaredComponent().getName());
        buf.append(",declaredpath:").append(this.getDeclaredPath() == null ? "null" : this.getDeclaredPath().toString()).append("}");
        return buf.toString();
    }
}

