/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.AssigningStep;
import com.raplix.rolloutexpress.systemmodel.plandb.BlockCallerStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotPrepareStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CallStep
extends ExecStep
implements TargetVariableStep,
SimplePlanStep,
SnapshotPrepareStep,
BlockCallerStep,
AssigningStep {
    private String mAssignTo;
    public static final String ELEMENT_NAME = "call";
    private static final String ELEMENT_ASSIGN = "assign";
    private static final String ATTR_VARNAME = "varName";
    protected String mBlockName;
    private InstalledComponentTargeter mTargeter;
    private ArgList mArgs;

    private CallStep() {
    }

    public CallStep(Element inElement) throws SystemModelParseException {
        super(inElement);
        this.mBlockName = inElement.getAttribute("blockName");
        this.setTargeter(ComponentTargeterFactory.getInstalledTargeter(inElement));
        this.mArgs = new ArgList(inElement);
        Element[] elements = CallStep.getChildren(inElement, ELEMENT_ASSIGN);
        if (elements.length > 0) {
            this.setAssignTo(CallStep.getAttribute(elements[0], ATTR_VARNAME));
        }
    }

    public CallStep(String inBlockName, InstalledComponentTargeter targeter) {
        this(inBlockName, targeter, new ArgList());
    }

    public CallStep(String inBlockName, InstalledComponentTargeter targeter, VariableSettingsSource args) {
        this(inBlockName, targeter, args, null);
    }

    public CallStep(String inBlockName, InstalledComponentTargeter targeter, VariableSettingsSource args, String inAssignVarName) {
        this.setBlockName(inBlockName);
        this.setTargeter(targeter);
        this.setArgs(args);
        this.setAssignTo(inAssignVarName);
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public void setBlockName(String inValue) {
        this.mBlockName = inValue;
    }

    public InstalledComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(InstalledComponentTargeter targeter) {
        if (targeter == null) {
            targeter = new ThisTargeter();
        }
        this.mTargeter = targeter;
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        this.mArgs = args == null ? new ArgList() : new ArgList(args);
    }

    public NamedBlockType getBlockType() {
        return NamedBlockType.CONTROL;
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    protected void populateXML(XML outXML) {
        outXML.setPrettyPrint(true);
        CallStep.addAttributeIfNotNull(outXML, "blockName", this.mBlockName);
        this.mArgs.writeToXML(outXML);
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
        if (this.getAssignTo() != null) {
            XML assign = new XML(ELEMENT_ASSIGN);
            assign.setPrettyPrint(true);
            CallStep.addAttributeIfNotNull(assign, ATTR_VARNAME, this.getAssignTo());
            outXML.addElement((org.apache.ecs.Element)assign);
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CallStep)) {
            return false;
        }
        CallStep theStep = (CallStep)inStep;
        if (!theStep.getBlockName().equals(this.mBlockName)) {
            return false;
        }
        if (!this.equals(theStep.getTargeter(), this.getTargeter())) {
            return false;
        }
        return this.mArgs.equals(theStep.getArgs());
    }

    public int getStepType() {
        return 102;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        CallStep copy = (CallStep)super.generate(generator);
        copy.setTargeter((InstalledComponentTargeter)copy.mTargeter.generate(generator));
        copy.mArgs = copy.mArgs.generate(generator);
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
        v.visit(this.mArgs);
        v.visitMutableVar(this.getAssignTo());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        CallStep result = (CallStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }

    public String getAssignTo() {
        return this.mAssignTo;
    }

    public void setAssignTo(String inVarname) {
        this.mAssignTo = inVarname;
    }
}

