/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotPrepareStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class AssignStep
extends ExecStep
implements SimplePlanStep,
ComponentStep,
SnapshotPrepareStep {
    private String mVarName;
    private String mValue;
    public static final String ELEMENT_NAME = "assign";
    private static final String VALUE_ATTR = "value";
    private static final String VARNAME_ATTR = "varName";

    public AssignStep(Element inElement) {
        super(inElement);
        this.setValue(inElement.getAttribute(VALUE_ATTR));
        this.setVarName(inElement.getAttribute(VARNAME_ATTR));
    }

    public AssignStep() {
    }

    public AssignStep(String inVarname, String inValue) {
        this();
        this.setVarName(inVarname);
        this.setValue(inValue);
    }

    protected void populateXML(XML outXML) {
        AssignStep.addAttributeIfNotNull(outXML, VALUE_ATTR, this.getValue());
        outXML.addAttribute(VARNAME_ATTR, this.getVarName());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof AssignStep)) {
            return false;
        }
        AssignStep rStep = (AssignStep)inStep;
        if (this.getValue() == null) {
            if (this.getVarName() == null) {
                return rStep.getValue() == null && rStep.getVarName() == null;
            }
            return this.getVarName().equals(rStep.getVarName());
        }
        if (this.getVarName() == null) {
            return this.getValue().equals(rStep.getValue()) && rStep.getVarName() == null;
        }
        return this.getValue().equals(rStep.getValue()) && this.getVarName().equals(rStep.getVarName());
    }

    public int getStepType() {
        return 139;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(String inValue) {
        this.mValue = inValue;
    }

    public String getVarName() {
        return this.mVarName;
    }

    public void setVarName(String inVarName) {
        this.mVarName = inVarName;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        AssignStep copy = (AssignStep)super.generate(generator);
        copy.setValue(generator.generate(this.getValue()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getValue());
        v.visitMutableVar(this.getVarName());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        AssignStep result = (AssignStep)super.accept(t);
        result.setValue(t.transformToken(this.getValue()));
        return result;
    }
}

