/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.sun.n1.util.vars.VariableSettingsSource;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ArgList
extends VariableSettingsHolder {
    private static final int MAX_NAME_LEN = 512;
    public static final String ELEMENT_NAME = "argList";

    public ArgList() {
    }

    public ArgList(VariableSettingsSource args) {
        super(args);
    }

    public ArgList(Element topElement) throws SystemModelParseException {
        Element[] argLists = XMLUtil.getChildren(topElement, ELEMENT_NAME);
        if (argLists.length > 0) {
            NamedNodeMap attrs = argLists[0].getAttributes();
            int numAttrs = attrs.getLength();
            if (numAttrs == 0) {
                throw ArgList.noArgs();
            }
            for (int i = 0; i < numAttrs; ++i) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getName();
                ArgList.validateName(name);
                String value = attr.getValue();
                this.setVarValue(name, value);
            }
        }
    }

    private static void validateName(String name) throws SystemModelParseException {
        if (name == null) {
            throw ArgList.invalidName(name);
        }
        int len = name.length();
        if (len < 1 || len > 512) {
            throw ArgList.invalidName(name);
        }
        if (!ArgList.isValidNameStart(name.charAt(0))) {
            throw ArgList.invalidName(name);
        }
        for (int i = 1; i < len; ++i) {
            if (ArgList.isValidNameChar(name.charAt(i))) continue;
            throw ArgList.invalidName(name);
        }
    }

    private static boolean isValidNameStart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    private static boolean isValidNameChar(char ch) {
        return ArgList.isValidNameStart(ch) || ch >= '0' && ch <= '9';
    }

    private static SystemModelParseException invalidName(String name) {
        ROXMessage message = new ROXMessage("pdb.INVALID_ARG_NAME", (Object[])new String[]{name}, 2000);
        return new SystemModelParseException(message);
    }

    private static SystemModelParseException noArgs() {
        ROXMessage message = new ROXMessage("pdb.NO_ARGS_IN_ARGLIST", (Object[])new String[0], 2000);
        return new SystemModelParseException(message);
    }

    public void writeToXML(XML topElem) {
        if (this.size() > 0) {
            XML varList = new XML(ELEMENT_NAME);
            varList.setPrettyPrint(true);
            String[] names = this.getVarNames();
            for (int i = 0; i < names.length; ++i) {
                String val = this.getVarValue(names[i]);
                XMLUtil.addAttributeIfNotNull(varList, names[i], val);
            }
            topElem.addElement((org.apache.ecs.Element)varList);
        }
    }

    public ArgList generate(ConfigGenerator generator) throws ConfigGenException {
        ArgList result = (ArgList)this.clone();
        String[] names = result.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String val = generator.generate(result.getVarValue(names[i]));
            result.setVarValue(names[i], val);
        }
        return result;
    }
}

