/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Element;

public class AllNestedRefsTargeter
extends ComponentTargeterBase
implements RepoComponentTargeter,
InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "allNestedRefs";

    public AllNestedRefsTargeter() {
    }

    AllNestedRefsTargeter(Element element) {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.ALL_NESTED_REFS");
    }

    public boolean isBulkTargeter() {
        return true;
    }

    private ComponentRefDecl[] resolveAllRefs(Caller caller) throws PersistenceManagerException, RPCException {
        ComponentRefDecl[] allRefs = caller.getActualComponent().getCompRefList(null);
        Vector<ComponentRefDecl> result = new Vector<ComponentRefDecl>();
        for (int i = 0; i < allRefs.length; ++i) {
            if (!InstallMode.NESTED.equals(allRefs[i].getInstallMode())) continue;
            result.add(allRefs[i]);
        }
        return result.toArray(new ComponentRefDecl[result.size()]);
    }

    private InstalledComponent resolveInstComp(TargetedConfigContext ctx, Caller caller, ComponentRefDecl compRef, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        return installDBContext.getNestedComponent(caller.getInstalledComponent().getID(), compRef.getName());
    }

    public RepoTarget[] getAllRepoTargets(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        Host h = ctx.getTargetHost();
        ComponentRefDecl[] refs = this.resolveAllRefs(caller);
        RepoTarget[] result = new RepoTarget[refs.length];
        for (int i = 0; i < result.length; ++i) {
            Component target = refs[i].getComponent().getID().getByIDQuery().select();
            if (this.resolveInstComp(ctx, caller, refs[i], installDBContext) != null) {
                Component callerComp = caller.getActualComponent();
                String refName = refs[i].getName();
                throw PlanDBException.compRefAlreadyInstalled(callerComp, refName);
            }
            result[i] = new RepoTarget(target, this.getDeclaredTypeOfRef(refs[i], caller), h, caller, refs[i], this);
        }
        return result;
    }

    public InstalledTarget[] getAllInstalledTargets(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        ComponentRefDecl[] refs = this.resolveAllRefs(caller);
        HashMap<String, ComponentRefDecl> refMap = new HashMap<String, ComponentRefDecl>();
        for (int i = 0; i < refs.length; ++i) {
            refMap.put(refs[i].getName(), refs[i]);
        }
        InstalledComponent[] instComps = installDBContext.getNestedComponents(caller.getInstalledComponent().getID());
        InstalledTarget[] result = new InstalledTarget[instComps.length];
        for (int i = 0; i < result.length; ++i) {
            Host h = this.getHost(instComps[i], ctx);
            ComponentRefDecl ref = (ComponentRefDecl)refMap.get(instComps[i].getParentContainerRefName());
            result[i] = new InstalledTarget(instComps[i], this.getDeclaredTypeOfRef(ref, caller), h, caller, (ComponentTargeterBase)this);
        }
        return result;
    }

    public void validate(Caller container) throws PlanDBException {
        Component comp = container.getDeclaredComponent();
        if (comp == null || comp.isSimpleComponent()) {
            throw PlanDBException.allNestedRefsInSimpleComp();
        }
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other instanceof AllNestedRefsTargeter;
    }
}

