/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class AllDependantsTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "allDependants";
    private static final String NAME_ATTR = "name";
    private String mDependantName;

    public AllDependantsTargeter(String dependantName) {
        this.setDependantName(dependantName);
    }

    AllDependantsTargeter(Element element) {
        this.setDependantName(XMLUtil.getAttribute(element, NAME_ATTR));
    }

    private AllDependantsTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.ALL_DEPENDANTS", this.getDependantName());
    }

    public String getDependantName() {
        return this.mDependantName;
    }

    private void setDependantName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mDependantName = name;
    }

    public boolean isBulkTargeter() {
        return true;
    }

    public InstalledTarget[] getAllInstalledTargets(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException {
        String name = this.getDependantName();
        InstalledComponentID callerInstCompID = caller.getInstalledComponent().getID();
        Dependency[] deps = idbCtx.queryDependantsOf(callerInstCompID, name);
        InstalledTarget[] result = new InstalledTarget[deps.length];
        for (int i = 0; i < deps.length; ++i) {
            InstalledComponentID instCompID = deps[i].getDependantInstalledComponentID();
            InstalledComponent instComp = idbCtx.getInstalledComponent(instCompID);
            Component declared = instComp.getComponentID().getByIDQuery().select();
            String typeName = deps[i].getDependantDeclaredComponentExtendsTypeName();
            declared = declared.getAncestorByExtendsTypeName(typeName);
            result[i] = new InstalledTarget(instComp, declared, this.getHost(instComp, ctx), caller, (ComponentTargeterBase)this);
        }
        return result;
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getDependantName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AllDependantsTargeter)) {
            return false;
        }
        AllDependantsTargeter targeter = (AllDependantsTargeter)other;
        return ObjectUtil.equals(this.getDependantName(), targeter.getDependantName());
    }
}

