/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.IDValueProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotToHostLinkTable;
import com.raplix.util.collections.CollectionUtil;

class SnapshotToHostLinkSQLOps
extends SnapshotToHostLinkTable {
    public static final SnapshotToHostLinkSQLOps DEFAULT = new SnapshotToHostLinkSQLOps();

    public SnapshotToHostLinkSQLOps(String alias) {
        super(alias);
    }

    private SnapshotToHostLinkSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new SnapshotToHostLinkSQLOps(alias);
    }

    public Select selectSnapshotIDs(HostID inHostID) {
        return this.selectParentIDs(inHostID);
    }

    public Select selectHostIDs(SnapshotID inSnapshotID) {
        return this.selectChildIDs(inSnapshotID);
    }

    public HostID[] getVisitedHosts(SnapshotID inSnapshotID) throws PersistenceManagerException {
        IDValueProcessor idProc = new IDValueProcessor(this.ChildID);
        SnapshotToHostLinkSQLOps.execute(this.selectHostIDs(inSnapshotID), idProc);
        return (HostID[])CollectionUtil.mapClass(idProc.getRetrievedValues(), HostID.class);
    }

    public int addLink(SnapshotID inSnapshotID, HostID inHostID) throws PersistenceManagerException {
        return super.addLink(inSnapshotID, inHostID);
    }

    public int removeLinks(SnapshotID inSnapshotID) throws PersistenceManagerException {
        return super.removeByParentID(inSnapshotID);
    }

    public int removeLinks(HostID inHostID) throws PersistenceManagerException {
        return super.removeByChildID(inHostID);
    }
}

