/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotStatus;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotTable;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotToHostLinkSQLOps;

class SnapshotSQLOps
extends SnapshotTable {
    public static final SnapshotSQLOps DEFAULT = new SnapshotSQLOps();

    public SnapshotSQLOps(String alias) {
        super(alias);
    }

    private SnapshotSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new SnapshotSQLOps(alias);
    }

    public ConditionalExpression isInstalledBy(InstalledComponentID installer) {
        return SnapshotSQLOps.equals(this.InstalledComponentID, installer);
    }

    public ConditionalExpression equalsStatus(SnapshotStatus status) {
        return SnapshotSQLOps.equals(this.Status, status);
    }

    public OrderByList orderByInstallOrderAsc(QueryContext ctx) {
        return SnapshotSQLOps.oList(SnapshotSQLOps.orderByAsc(this.InstallOrder));
    }

    public ConditionalExpression isInstalledOn(HostID inPhysHostID) {
        SnapshotToHostLinkSQLOps table = SnapshotToHostLinkSQLOps.DEFAULT;
        InstalledComponentSQLOps icTable = InstalledComponentSQLOps.DEFAULT;
        return SnapshotSQLOps.and(SnapshotSQLOps.in((ColumnNode)this.ID, table.selectSnapshotIDs(inPhysHostID)), SnapshotSQLOps.exists(SnapshotSQLOps.select(SnapshotSQLOps.sList(icTable.ID), SnapshotSQLOps.tList(icTable), SnapshotSQLOps.where(SnapshotSQLOps.and(SnapshotSQLOps.equals((ColumnNode)icTable.ID, this.InstalledComponentID), SnapshotSQLOps.isNull(icTable.UninstallDate))))));
    }
}

