/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.SingleSnapshotQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotToHostLinkSQLOps;
import com.raplix.util.logger.Logger;

public class SnapshotID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private SnapshotID() {
    }

    public SnapshotID(String key) {
        super(key);
    }

    public SingleSnapshotQuery getByIDQuery() {
        return new SingleSnapshotQuery(this);
    }

    public static SnapshotID generateID() {
        return (SnapshotID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Examining Snapshot " + this.toString() + " for dependent objects", "persist.objectdeletion");
        }
        try {
            InstalledComponent ic;
            Snapshot s = this.getByIDQuery().select();
            if (s.getInstalledComponentID() != null && (ic = s.getInstalledComponentID().getByIDQuery().select()).isInstalled() && !inContext.objectWillBeDeletedAfter(ic.getID(), this)) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Snapshot is in use by installed component", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{new InstalledComponentBean(ic.getRootContainerID())});
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        SnapshotIDSet idset = new SnapshotIDSet();
        idset.add(this);
        return idset;
    }

    public void addVisitedHostMS(HostID inHostID) throws PersistenceManagerException, RPCException {
        SnapshotToHostLinkSQLOps.DEFAULT.addLink(this, inHostID);
    }

    protected void deleteMS(final PersistContext context) throws PersistenceManagerException {
        SnapshotID.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                SnapshotID.this.trDeleteMS(context);
                return null;
            }
        });
    }

    private void trDeleteMS(PersistContext context) throws PersistenceManagerException {
        SnapshotToHostLinkSQLOps.DEFAULT.removeLinks(this);
        super.deleteMS(context);
    }

    public HostID[] getVisitedHosts() throws PersistenceManagerException, RPCException {
        return ((HostIDArrayWrapper)SnapshotID.transactRPC(new SnapshotHostRetrieveTxn(this))).getHostIDs();
    }

    private static class HostIDArrayWrapper
    extends PersistContext {
        private HostID[] mHostIDs;

        public HostID[] getHostIDs() {
            return this.mHostIDs;
        }

        public HostIDArrayWrapper(HostID[] inHostIDs) {
            this.mHostIDs = inHostIDs;
        }

        private HostIDArrayWrapper() {
        }
    }

    private static class SnapshotHostRetrieveTxn
    extends RPCTransaction {
        private SnapshotID mSnapshotID;

        public SnapshotHostRetrieveTxn(SnapshotID inSnapshotID) {
            this.mSnapshotID = inSnapshotID;
        }

        protected PersistContext executeMS() throws PersistenceManagerException {
            return new HostIDArrayWrapper(SnapshotToHostLinkSQLOps.DEFAULT.getVisitedHosts(this.mSnapshotID));
        }

        private SnapshotHostRetrieveTxn() {
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new SnapshotID(inID);
        }
    }
}

