/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotStatus;

public class Snapshot
extends PersistentBean
implements UsingObject {
    private InstalledComponentID mInstalledComponentID;
    private String mName;
    private int mInstallOrder;
    private SnapshotStatus mStatus = SnapshotStatus.CREATED;
    private String mCreatorExtendsTypeName;

    private Snapshot() {
    }

    public Snapshot(InstalledComponentID installedComp, String name, int order, String creatorExtendsTypeName) {
        this.setInstalledComponentID(installedComp);
        this.setName(name);
        this.setInstallOrder(order);
        this.setCreatorExtendsTypeName(creatorExtendsTypeName);
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public SnapshotID getID() {
        return (SnapshotID)super.getObjectID();
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    private void setInstalledComponentID(InstalledComponentID installedComponentID) {
        if (installedComponentID == null) {
            throw new NullPointerException();
        }
        this.mInstalledComponentID = installedComponentID;
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public String getDescription() {
        return this.getName();
    }

    public int getInstallOrder() {
        return this.mInstallOrder;
    }

    private void setInstallOrder(int installOrder) {
        this.mInstallOrder = installOrder;
    }

    public SnapshotStatus getStatus() {
        return this.mStatus;
    }

    public void setStatus(SnapshotStatus status) {
        this.mStatus = status;
    }

    public String getCreatorExtendsTypeName() {
        return this.mCreatorExtendsTypeName;
    }

    private void setCreatorExtendsTypeName(String creatorExtendsTypeName) {
        this.mCreatorExtendsTypeName = creatorExtendsTypeName;
    }

    public int getUpdateCount() {
        return super.getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    public void save() throws PersistenceManagerException, RPCException {
        this.saveRPC(null);
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("name=").append(this.mName).append("(").append(this.mInstallOrder).append(") of ICID " + this.mInstalledComponentID);
        return output.toString();
    }
}

