/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.installdb.Messages;

public class PersistentInstalledResource
extends PersistentObject
implements RPCSerializable,
Messages {
    private InstalledComponentID mInstalledComponentID;
    private ResourceID mResourceID;
    private String mInstallPath;

    public PersistentInstalledResource() {
    }

    PersistentInstalledResource(InstalledResourceID installedResourceID) throws InstallDBException, NoResultsFoundException {
        try {
            this.setObjectID(installedResourceID);
            this.retrieve();
        }
        catch (NoResultsFoundException e) {
            throw e;
        }
        catch (PersistenceManagerException e) {
            throw InstallDBException.retrieveError(e);
        }
    }

    PersistentInstalledResource(InstalledComponentID installedComponentID, ResourceID resourceID, String installPath) {
        this.setInstalledComponentID(installedComponentID);
        this.setResourceID(resourceID);
        this.setInstallPath(installPath);
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public void setInstalledComponentID(InstalledComponentID installedComponentID) {
        this.mInstalledComponentID = installedComponentID;
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.mResourceID = resourceID;
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    public void setInstallPath(String installPath) {
        this.mInstallPath = installPath;
    }

    public boolean equalsData(PersistentInstalledResource other) {
        return this.getResourceID().equals(other.getResourceID()) && this.getInstalledComponentID().equals(other.getInstalledComponentID()) && this.getInstallPath().equals(other.getInstallPath());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString()).append('\n');
        buf.append('\t').append("InstalledResourceID: ").append(this.getObjectID()).append('\n');
        buf.append('\t').append("InstalledComponentID: ").append(this.getInstalledComponentID()).append('\n');
        buf.append('\t').append("ResourceID: ").append(this.getResourceID()).append('\n');
        buf.append('\t').append("InstallPath: ").append(this.getInstallPath()).append('\n');
        return buf.toString();
    }
}

