/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallStatus;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledCompToInstalledCompLinkTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.Messages;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.ObjectUtil;
import java.util.Date;

public class PersistentInstalledComponent
extends PersistentObject
implements RPCSerializable,
Messages {
    private ComponentID mComponentID;
    private String mInstallPath;
    private InstalledComponentID mParentContainerID;
    private String mParentContainerRefName;
    private InstalledComponentID mRootContainerID;
    private InstalledComponentID mReachableContainerID;
    private TargetID mTargetID;
    private GeneratedVariableSettingsID mVariableSettingsID;
    private TaskID mTaskID;
    private ExecutionPlanID mPlanID;
    private String mInstallBlockName;
    private Date mInstallDate;
    private Date mUninstallDate;
    private InstallStatus mInstallStatus;

    public PersistentInstalledComponent() {
    }

    PersistentInstalledComponent(ComponentID componentID, String installPath, InstalledComponent parentContainer, String parentContainerRefName, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName) throws InstallDBException {
        this.setComponentID(componentID);
        if (installPath == null || installPath.length() == 0) {
            throw InstallDBException.invalidInstallPath(this.getComponentID());
        }
        this.setInstallPath(installPath);
        if (parentContainer != null) {
            this.setParentContainerID(parentContainer.getID());
            this.setRootContainerID(parentContainer.getRootContainerID());
        }
        this.setParentContainerRefName(parentContainerRefName);
        this.setTargetID(targetID);
        this.setVariableSettingsID(varSettingsID);
        this.setTaskID(taskID);
        this.setPlanID(planID);
        this.setInstallBlockName(installBlockName);
    }

    InstalledComponentID getID() {
        return (InstalledComponentID)this.getObjectID();
    }

    public ComponentID getComponentID() {
        return this.mComponentID;
    }

    public void setComponentID(ComponentID componentID) {
        this.mComponentID = componentID;
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    public void setInstallPath(String installPath) throws InstallDBException {
        this.mInstallPath = installPath;
    }

    public InstalledComponentID getParentContainerID() {
        return this.mParentContainerID;
    }

    public void setParentContainerID(InstalledComponentID parentContainerID) {
        this.mParentContainerID = parentContainerID;
    }

    public String getParentContainerRefName() {
        return this.mParentContainerRefName;
    }

    public void setParentContainerRefName(String parentContainerRefName) {
        this.mParentContainerRefName = parentContainerRefName;
    }

    public InstalledComponentID getRootContainerID() {
        if (this.mRootContainerID == null) {
            this.mRootContainerID = this.getID();
        }
        return this.mRootContainerID;
    }

    public void setRootContainerID(InstalledComponentID rootContainerID) {
        this.mRootContainerID = rootContainerID;
    }

    public InstalledComponentID getReachableContainerID() {
        if (this.mReachableContainerID == null) {
            this.mReachableContainerID = this.getID();
        }
        return this.mReachableContainerID;
    }

    public void setReachableContainerID(InstalledComponentID reachableContainerID) {
        this.mReachableContainerID = reachableContainerID;
    }

    public TargetID getTargetID() {
        return this.mTargetID;
    }

    public void setTargetID(TargetID targetID) {
        this.mTargetID = targetID;
    }

    public GeneratedVariableSettingsID getVariableSettingsID() {
        return this.mVariableSettingsID;
    }

    public void setVariableSettingsID(GeneratedVariableSettingsID variableSettingsID) {
        this.mVariableSettingsID = variableSettingsID;
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public void setTaskID(TaskID taskID) {
        this.mTaskID = taskID;
    }

    public ExecutionPlanID getPlanID() {
        return this.mPlanID;
    }

    public void setPlanID(ExecutionPlanID planID) {
        this.mPlanID = planID;
    }

    public String getInstallBlockName() {
        return this.mInstallBlockName;
    }

    public void setInstallBlockName(String installBlockName) {
        this.mInstallBlockName = installBlockName;
    }

    public Date getInstallDate() {
        return this.mInstallDate;
    }

    public void setInstallDate(Date inInstallDate) {
        this.mInstallDate = inInstallDate;
    }

    public Date getUninstallDate() {
        return this.mUninstallDate;
    }

    public void setUninstallDate(Date inUninstallDate) {
        this.mUninstallDate = inUninstallDate;
    }

    private InstallStatus getInstallStatus() {
        return this.mInstallStatus;
    }

    private void setInstallStatus(InstallStatus inInstallStatus) {
        this.mInstallStatus = inInstallStatus;
    }

    public boolean equalsData(PersistentInstalledComponent other) {
        return this.getComponentID().equals(other.getComponentID()) && this.getInstallPath().equals(other.getInstallPath()) && ObjectUtil.equals(this.getParentContainerID(), other.getParentContainerID()) && ObjectUtil.equals(this.getParentContainerRefName(), other.getParentContainerRefName()) && this.getTargetID().equals(other.getTargetID()) && this.getVariableSettingsID().equals(other.getVariableSettingsID()) && this.getTaskID().equals(other.getTaskID()) && this.getPlanID().equals(other.getPlanID()) && this.getInstallBlockName().equals(other.getInstallBlockName()) && ObjectUtil.equals(this.getInstallDate(), other.getInstallDate()) && ObjectUtil.equals(this.getUninstallDate(), other.getUninstallDate());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString()).append('\n');
        buf.append('\t').append("InstalledComponentID: ").append(this.getObjectID()).append('\n');
        buf.append('\t').append("ComponentID: ").append(this.getComponentID()).append('\n');
        buf.append('\t').append("InstallPath: ").append(this.getInstallPath()).append('\n');
        buf.append('\t').append("ParentContainerID: ").append(this.getParentContainerID()).append('\n');
        buf.append('\t').append("ParentContainerRefName: ").append(this.getParentContainerRefName()).append('\n');
        buf.append('\t').append("TargetID: ").append(this.getTargetID()).append('\n');
        buf.append('\t').append("VariableSettingsID: ").append(this.getVariableSettingsID()).append('\n');
        buf.append('\t').append("TaskID: ").append(this.getTaskID()).append('\n');
        buf.append('\t').append("PlanID: ").append(this.getPlanID()).append('\n');
        buf.append('\t').append("InstallBlockName: ").append(this.getInstallBlockName()).append('\n');
        buf.append('\t').append("InstallDate: ").append(this.getInstallDate()).append('\n');
        buf.append('\t').append("UninstallDate: ").append(this.getUninstallDate()).append('\n');
        buf.append('\t').append("InstallStatus: ").append(this.getInstallStatus()).append('\n');
        return buf.toString();
    }

    protected static Object retryOnDeadlock(ReEntrantTransaction inTR) throws PersistenceManagerException {
        return PersistentBean.retryOnDeadlock(inTR);
    }

    public void save() throws PersistenceManagerException {
        PersistentInstalledComponent.retryOnDeadlock(new ReEntrantSave(this));
    }

    protected void saveMS(final PersistContext ctx) throws PersistenceManagerException {
        PersistentInstalledComponent.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                PersistentInstalledComponent.this.trSaveMS(ctx);
                return null;
            }
        });
    }

    private void trSaveMS(PersistContext ctx) throws PersistenceManagerException {
        super.saveMS(ctx);
        InstalledComponentID parentID = this.getParentContainerID();
        if (parentID != null) {
            InstalledComponentID curID = this.getID();
            InstalledCompToInstalledCompLinkTable lt = InstalledCompToInstalledCompLinkTable.DEFAULT;
            Select newLinks = lt.select(InstalledCompToInstalledCompLinkTable.sList(lt.ParentID, (ScalarExp)InstalledCompToInstalledCompLinkTable.v(curID)), InstalledCompToInstalledCompLinkTable.where(InstalledCompToInstalledCompLinkTable.equals(lt.ChildID, parentID)));
            newLinks = InstalledCompToInstalledCompLinkTable.anonSelect(InstalledCompToInstalledCompLinkTable.sList(InstalledCompToInstalledCompLinkTable.v(parentID), (ScalarExp)InstalledCompToInstalledCompLinkTable.v(curID)), newLinks);
            lt.addLinks(newLinks);
        }
    }

    protected SaveResult createSaveResult() {
        return new ICSaveResult(this);
    }

    protected void setSaveResult(SaveResult result) throws PersistenceManagerException {
        ICSaveResult icResult = (ICSaveResult)result;
        super.setSaveResult(result);
        this.mRootContainerID = icResult.mRootContainerID;
        this.mReachableContainerID = icResult.mReachableContainerID;
    }

    private static class ReEntrantSave
    implements ReEntrantTransaction {
        private PersistentInstalledComponent mIComp;

        ReEntrantSave(PersistentInstalledComponent icomp) {
            this.mIComp = icomp;
        }

        public Object execute() throws PersistenceManagerException {
            this.mIComp.safeSaveMS(null);
            return null;
        }
    }

    private static class ICSaveResult
    extends SaveResult {
        InstalledComponentID mRootContainerID;
        InstalledComponentID mReachableContainerID;

        ICSaveResult(PersistentInstalledComponent ic) {
            super(ic);
            this.mRootContainerID = ic.mRootContainerID;
            this.mReachableContainerID = ic.mReachableContainerID;
        }
    }
}

