/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXComponentEvent;
import com.raplix.rolloutexpress.event.ROXComponentInstallEvent;
import com.raplix.rolloutexpress.event.ROXComponentUninstallEvent;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ReservationNotFoundException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyCheckInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyViolationException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContextBase;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiDependencyQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.SingleInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class PersistentInstallDBContext
extends InstallDBContextBase
implements InstallDBContext {
    public InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        return this.createInstalledComponent(componentID, installPath, null, null, targetID, varSettingsID, taskID, planID, installBlockName, ctx, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, InstalledComponent parentContainer, String parentContainerRefName, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        Component theComponent = componentID.getByIDQuery().select();
        InstalledComponent newInstalledComponent = this.newInstalledComponent(componentID, installPath, parentContainer, parentContainerRefName, targetID, varSettingsID, taskID, planID, installBlockName);
        InstalledComponent previousInstalledComp = this.isUpgrade(newInstalledComponent, ctx, caller);
        if (previousInstalledComp != null) {
            this.canUpgrade(newInstalledComponent, previousInstalledComp, ctx, caller);
        }
        TargetRef tr = null;
        if (null != theComponent) {
            tr = theComponent.getTargetRef();
        }
        HostReservationID rid = null;
        if (null != tr) {
            try {
                TargetRef trcg = this.cgTargetRef(newInstalledComponent, tr);
                Host.validateTargetableComponentHost(trcg);
                rid = PersistentInstallDBContext.reserveHostForTR(trcg, previousInstalledComp);
            }
            catch (TransportException e) {
                throw new InstallDBException(e);
            }
            catch (ConfigGenException e) {
                throw new InstallDBException(e);
            }
        }
        newInstalledComponent.setTargetableHostReservationID(rid);
        boolean saveFailed = true;
        try {
            newInstalledComponent.getData().save();
            return newInstalledComponent;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            if (!saveFailed || rid == null) throw throwable;
            HostDBSubsystem.getInstance().releaseReservation(rid);
            throw throwable;
        }
    }

    static HostReservationID reserveHostForTR(TargetRef trcg, InstalledComponent prevInstComp) throws TransportException, PersistenceManagerException, RPCException {
        HostReservationID rid = null;
        if (prevInstComp == null) {
            rid = HostDBSubsystem.getInstance().reserveHost(trcg.getHostName(), trcg.getIPAddr());
        } else {
            Host previouslyInstalledTargetRefHost = SingleHostQuery.byInstalledComponentID(prevInstComp.getID()).select();
            if (!previouslyInstalledTargetRefHost.getName().equals(trcg.getHostName())) {
                rid = HostDBSubsystem.getInstance().reserveHost(trcg.getHostName(), null);
            }
        }
        return rid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installComponent(InstalledComponent installedComp, TargetedConfigContext ctx, Caller caller, NotificationManager notificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        try {
            InstalledComponent previousInstalledComp = this.isUpgrade(installedComp, ctx, caller);
            ROXComponentInstallEvent installEvent = ROXComponentEvent.install(installedComp.getID(), false);
            InstalledComponentSQLOps.DEFAULT.installComponent(installedComp, previousInstalledComp, installEvent.getDate());
            installedComp.getData().setInstallDate(installEvent.getDate());
            notificationManager.notifyAndWait(installEvent);
            Object var8_7 = null;
            if (installedComp == null) return;
            if (installedComp.getTargetableHostReservationID() == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (installedComp == null || installedComp.getTargetableHostReservationID() == null) throw throwable;
            HostDBSubsystem.getInstance().releaseReservation(installedComp.getTargetableHostReservationID());
            throw throwable;
        }
        HostDBSubsystem.getInstance().releaseReservation(installedComp.getTargetableHostReservationID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installComponentFailed(InstalledComponent inComp) throws InstallDBException, RPCException, PersistenceManagerException {
        try {
            InstalledComponentSQLOps.DEFAULT.uninstallComponent(inComp, new Date(), null);
            Object var3_2 = null;
            if (inComp == null) return;
            if (inComp.getTargetableHostReservationID() == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (inComp == null || inComp.getTargetableHostReservationID() == null) throw throwable;
            try {
                HostDBSubsystem.getInstance().releaseReservation(inComp.getTargetableHostReservationID());
                throw throwable;
            }
            catch (ReservationNotFoundException e) {
                if (!Logger.isWarnEnabled(this)) throw throwable;
                Logger.warn(new ROXMessage("hostdb.NO_RESERVATION").toString(), this);
            }
            throw throwable;
        }
        try {
            HostDBSubsystem.getInstance().releaseReservation(inComp.getTargetableHostReservationID());
            return;
        }
        catch (ReservationNotFoundException e) {
            if (!Logger.isWarnEnabled(this)) return;
            Logger.warn(new ROXMessage("hostdb.NO_RESERVATION").toString(), this);
        }
    }

    public void uninstallComponent(InstalledComponent inComp, TargetedConfigContext ctx, Caller caller, NotificationManager inNotificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        ROXComponentUninstallEvent uninstallEvent = ROXComponentEvent.uninstall(inComp.getID(), false);
        InstalledComponentSQLOps.DEFAULT.uninstallComponent(inComp, uninstallEvent.getDate(), this.getUninstallerID(caller));
        inNotificationManager.notifyAndWait(uninstallEvent);
    }

    public Dependency createDependency(String inName, Caller caller, InstalledComponentTargeter inDependencyTargeter, TargetedConfigContext ctx) throws InstallDBException, PersistenceManagerException, RPCException {
        this.validateDependencyTarget(caller, inDependencyTargeter, ctx);
        Dependency dep = new Dependency(inName, caller, inDependencyTargeter, ctx, this);
        dep.save();
        return dep;
    }

    public Dependency[] queryDependenciesCreatedBy(InstalledComponentID creatingInstalledComponentID, String depName) throws RPCException, PersistenceManagerException {
        MultiDependencyQuery q = MultiDependencyQuery.byDependenciesCreatedBy(creatingInstalledComponentID);
        q.setNameFilter(depName);
        return q.select();
    }

    public Dependency[] queryDependantsOf(InstalledComponentID installedComponentID, String depName) throws RPCException, PersistenceManagerException {
        MultiDependencyQuery q = MultiDependencyQuery.byDependantsOf(installedComponentID);
        q.setNameFilter(depName);
        return q.select();
    }

    public InstalledComponent getInstalledComponent(HostID hostID, InstalledComponentRef compRef, TargetType lookupType) throws PersistenceManagerException, RPCException {
        MultiInstalledComponentQuery q = MultiInstalledComponentQuery.byCompRef(hostID, lookupType, compRef, null);
        InstalledComponent[] result = q.selectICView();
        if (result.length == 0) {
            return null;
        }
        if (PersistentInstallDBContext.shouldCheckCallCompatibility(compRef)) {
            ComponentID origID;
            try {
                origID = SingleComponentQuery.byRef(compRef).selectSummaryView().getID();
            }
            catch (NoResultsFoundException e) {
                return null;
            }
            for (int i = 0; i < result.length; ++i) {
                InstalledComponent ic = result[i];
                if (!ic.getComponentID().isCallCompatibleWith(origID)) continue;
                return ic;
            }
            return null;
        }
        return result[0];
    }

    public InstalledComponent getInstalledComponent(HostID hostID, String typeName, String installPath) throws PersistenceManagerException, RPCException {
        MultiInstalledComponentQuery q = MultiInstalledComponentQuery.byType(hostID, TargetType.CURRENT, typeName, installPath);
        q.setPageNum(1);
        q.setPageSize(1);
        InstalledComponent[] result = q.selectICView();
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    public InstalledComponent getNestedComponent(InstalledComponentID parentID, String compRefName) throws PersistenceManagerException, RPCException {
        SingleInstalledComponentQuery q = SingleInstalledComponentQuery.byParentContainer(parentID, compRefName);
        try {
            return q.select();
        }
        catch (NoResultsFoundException e) {
            return null;
        }
    }

    public InstalledComponent[] getNestedComponents(InstalledComponentID parentID) throws PersistenceManagerException, RPCException {
        MultiInstalledComponentQuery q = MultiInstalledComponentQuery.byParentContainer(parentID);
        return q.selectICView();
    }

    void canUpgrade(InstalledComponent newInstalledComp, InstalledComponent previousInstalledComp, TargetedConfigContext ctx, Caller caller) throws InstallDBException, PersistenceManagerException, RPCException {
        Component theComponent = newInstalledComp.getComponentID().getByIDQuery().select();
        this.validateReinstall(theComponent, newInstalledComp, previousInstalledComp);
        try {
            Dependency[] depArray = MultiDependencyQuery.byDependantsOf(previousInstalledComp.getID()).select();
            DependencyCheckInstallDBContext theContext = new DependencyCheckInstallDBContext(previousInstalledComp.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID(), newInstalledComp, this);
            for (int i = 0; i < depArray.length; ++i) {
                depArray[i].checkDependency(ctx.getTargetHost(), newInstalledComp, theContext);
            }
        }
        catch (DependencyViolationException e) {
            throw DependencyViolationException.cannotUpgradeComponentDoesNotSatisfyDependants(newInstalledComp, previousInstalledComp);
        }
    }
}

