/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotStatus;

public class MultiSnapshotQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final SnapshotSQLOps TABLE = new SnapshotSQLOps("ssT");
    private SnapshotStatus mStatusFilter;

    static MultiSnapshotQuery byInstaller(InstalledComponentID instCompID) {
        MultiSnapshotQuery result = new MultiSnapshotQuery(TABLE.isInstalledBy(instCompID));
        result.setObjectOrder(SnapshotOrder.BY_INSTALL_ORDER_ASC);
        result.setStatusFilter(SnapshotStatus.INSTALLED);
        return result;
    }

    public static MultiSnapshotQuery byHostID(HostID inPhysHostID) {
        MultiSnapshotQuery result = new MultiSnapshotQuery(TABLE.isInstalledOn(inPhysHostID));
        return result;
    }

    static MultiSnapshotQuery byIDs(SnapshotID[] IDs) {
        return new MultiSnapshotQuery(SnapshotSQLOps.emptyIn(MultiSnapshotQuery.TABLE.ID, SnapshotSQLOps.rList(IDs)));
    }

    private MultiSnapshotQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, SnapshotOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((SnapshotOrder)order);
    }

    public Snapshot[] select() throws RPCException, PersistenceManagerException {
        return (Snapshot[])this.selectBeans(Snapshot.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    public SnapshotStatus getStatusFilter() {
        return this.mStatusFilter;
    }

    public void setStatusFilter(SnapshotStatus statusFilter) {
        this.mStatusFilter = statusFilter;
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        SnapshotSQLOps t = (SnapshotSQLOps)this.getTable();
        if (this.getStatusFilter() != null) {
            ctx.addAndWhereCondition(t.equalsStatus(this.getStatusFilter()));
        }
    }
}

