/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceProcessor;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import com.raplix.util.logger.Logger;

public class MultiInstalledResourceQuery
extends MultiObjectQueryImplBase
implements MultiSelectableObjectQuery {
    private ConditionalExpression mQueryConditional;
    private Boolean mInstalledFilter = new Boolean(true);
    private HostID mHostFilter = null;
    private TargetType mTargetTypeFilter = null;
    public static final String ORDERNAME_BY_DATE_DESC = "date-";
    static final InstalledResourceSQLOps outterInstResourceTable = new InstalledResourceSQLOps("oires");
    static final InstalledComponentSQLOps outterInstComponentTable = new InstalledComponentSQLOps("oicomp");
    static final TargetSQLOps outterTargetTable = new TargetSQLOps("otar");
    public static final String MSG_QUERY_DURATION = "event.QUERY_DURATION";

    public static MultiInstalledResourceQuery all() {
        MultiInstalledResourceQuery mirq = new MultiInstalledResourceQuery((ConditionalExpression)null);
        mirq.setObjectOrder(InstalledResourceOrder.BY_DATE_DESC);
        return mirq;
    }

    public static MultiInstalledResourceQuery byResourceID(ResourceID resID) {
        ConditionalExpression matchesResource = outterInstResourceTable.matchesResource(resID);
        MultiInstalledResourceQuery irq = new MultiInstalledResourceQuery(matchesResource);
        irq.setObjectOrder(InstalledResourceOrder.BY_DATE_DESC);
        return irq;
    }

    public static MultiInstalledResourceQuery byInstallPath(String inInstallPath) {
        AndExp matchesPath = QueryBuilder.and(outterInstResourceTable.matchesInstallPath(inInstallPath), outterInstComponentTable.rootIsReachable());
        MultiInstalledResourceQuery irq = new MultiInstalledResourceQuery(matchesPath);
        irq.setObjectOrder(InstalledResourceOrder.BY_DATE_DESC);
        return irq;
    }

    public static MultiInstalledResourceQuery byIDs(InstalledResourceID[] IDs) {
        MultiInstalledResourceQuery mirq = new MultiInstalledResourceQuery(InstalledResourceSQLOps.emptyIn(MultiInstalledResourceQuery.outterInstResourceTable.ID, InstalledResourceSQLOps.rList(IDs)));
        mirq.setObjectOrder(InstalledResourceOrder.BY_DATE_DESC);
        mirq.setInstalledFilter(null);
        return mirq;
    }

    private MultiInstalledResourceQuery(ConditionalExpression cond) {
        super(InstalledResourceOrder.FACTORY);
        this.mQueryConditional = cond;
    }

    protected SelectList getSelectList() {
        return outterInstResourceTable.allColumns();
    }

    protected ConditionalExpression getWhereCondition() {
        AndExp where = QB.and();
        if (null != this.mQueryConditional) {
            where.add(this.mQueryConditional);
        }
        where.add(QueryBuilder.equals((ColumnNode)MultiInstalledResourceQuery.outterInstResourceTable.InstalledComponentID, MultiInstalledResourceQuery.outterInstComponentTable.ID));
        where.add(QueryBuilder.equals((ColumnNode)MultiInstalledResourceQuery.outterInstComponentTable.TargetID, MultiInstalledResourceQuery.outterTargetTable.ID));
        if (null != this.getInstalledFilter()) {
            where.add(this.getInstalledFilter().booleanValue() ? outterInstComponentTable.isInstalled() : QueryBuilder.not(outterInstComponentTable.isInstalled()));
        }
        if (null != this.getHostFilter()) {
            where.add(outterInstComponentTable.isOnHost(this.getHostFilter(), this.getTargetTypeFilter(), outterTargetTable));
        }
        return where;
    }

    protected TableList getTableList() {
        return QueryBuilder.tList(outterInstResourceTable, outterInstComponentTable, outterTargetTable);
    }

    public Boolean getInstalledFilter() {
        return this.mInstalledFilter;
    }

    public void setInstalledFilter(Boolean filter) {
        this.mInstalledFilter = filter;
    }

    public HostID getHostFilter() {
        return this.mHostFilter;
    }

    public TargetType getTargetTypeFilter() {
        return this.mTargetTypeFilter;
    }

    public void setHostFilter(HostID host, TargetType targetType) {
        this.mHostFilter = host;
        this.mTargetTypeFilter = targetType;
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    public InstalledResource[] select() throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        InstalledResourceProcessor resultProcessor = new InstalledResourceProcessor(outterInstResourceTable, false);
        InstalledResource[] result = (InstalledResource[])this.selectArray(this.getSelectStatement(), resultProcessor, InstalledResource.class);
        if (Logger.isInfoEnabled(this)) {
            String msg = ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"InstalledResourceQuery", new Long(System.currentTimeMillis() - time)});
            Logger.info(msg, this);
        }
        return result;
    }

    private static class InstalledResourceSQLOps
    extends PersistentInstalledResourceTable {
        public static final InstalledResourceSQLOps DEFAULT = new InstalledResourceSQLOps();

        public InstalledResourceSQLOps(String alias) {
            super(alias);
        }

        private InstalledResourceSQLOps() {
            this(null);
        }

        public Table instance() {
            return DEFAULT;
        }

        public Table instance(String alias) {
            return new InstalledResourceSQLOps(alias);
        }

        public ConditionalExpression matchesResource(ResourceID resID) {
            return InstalledResourceSQLOps.or(InstalledResourceSQLOps.equals(this.ResourceID, resID), InstalledResourceSQLOps.in((ColumnNode)this.ResourceID, this.queryResourcesDerivedFrom(resID)));
        }

        private Select queryResourcesDerivedFrom(ResourceID resID) {
            ResourceTable rT = new ResourceTable("rsctd");
            return rT.select(InstalledResourceSQLOps.sList(rT.ID), InstalledResourceSQLOps.where(InstalledResourceSQLOps.equals(rT.CustomParentID, resID)));
        }

        public ConditionalExpression matchesInstallPath(String installPath) {
            return InstalledResourceSQLOps.equals(this.InstallPath, installPath);
        }
    }
}

