/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.event.query.bean.ComponentBean;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.event.query.bean.UserBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetImplTable;
import com.raplix.rolloutexpress.executor.target.TargetProcessor;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentProcessor;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserDataTable;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;

public class MultiInstalledComponentQuery
extends MultiObjectQueryImplBase
implements MultiSelectableObjectQuery {
    private CategoryID mCategoryFilter;
    private Boolean mInstalledFilter = new Boolean(true);
    public static final String ORDERNAME_BY_DATE_ASC = "date+";
    public static final String ORDERNAME_BY_DATE_DESC = "date-";
    ConditionalExpression mQueryConditional;
    private boolean mIncludeCompTable;
    private boolean mIncludeTargetTable;
    private boolean mRetrieveCreatedTarget = false;
    static final InstalledComponentSQLOps outterInstCompTable = new InstalledComponentSQLOps("oicomp");
    static final ComponentImplTable outterCompTable = new ComponentImplTable("ocomp");
    static final PersistentUserDataTable outterUserTable = new PersistentUserDataTable("ousr");
    static final TargetSQLOps outterTargetTable = new TargetSQLOps("otar");
    static final TaskInfoTable outterTaskInfoTable = new TaskInfoTable("oti");
    static final ExecutionPlanImplTable outterPlanTable = new ExecutionPlanImplTable("opt");
    static final PersistentVariableSettingsTable outterGenVarsTable = new PersistentVariableSettingsTable("ogvt");
    static final HostImplTable outterHostTable = new HostImplTable("h");
    public static final String MSG_QUERY_DURATION = "event.QUERY_DURATION";

    public static MultiInstalledComponentQuery all() {
        MultiInstalledComponentQuery result = new MultiInstalledComponentQuery((ConditionalExpression)null);
        result.setObjectOrder(InstalledComponentOrder.BY_DATE_ASC);
        return result;
    }

    public static MultiInstalledComponentQuery byCompRef(HostID inHostID, TargetType inTargetType, InstalledComponentRef inCompRef, TaskID inTaskID) throws PersistenceManagerException {
        ConditionalExpression instComps = outterInstCompTable.equalsCompRef(inHostID, inTargetType, inCompRef, inTaskID, outterTargetTable, outterCompTable);
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        micq.setIncludeTargetTable(true);
        micq.setIncludeCompTable(true);
        return micq;
    }

    public static MultiInstalledComponentQuery byType(HostID hostID, TargetType targetType, String typeName, String installPath) {
        ConditionalExpression instComps = outterInstCompTable.isInstanceOf(hostID, targetType, typeName, installPath, outterTargetTable, outterCompTable);
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        micq.setIncludeTargetTable(true);
        micq.setIncludeCompTable(true);
        return micq;
    }

    public static MultiInstalledComponentQuery byType(String typeName) {
        ConditionalExpression instComps = outterInstCompTable.isInstanceOf(typeName, outterCompTable);
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        micq.setIncludeCompTable(true);
        return micq;
    }

    public static MultiInstalledComponentQuery byHost(HostID inHostID, TargetType inTargetType) {
        if (inHostID == null) {
            throw new NullPointerException();
        }
        AndExp instComps = QueryBuilder.and(outterInstCompTable.isOnHost(inHostID, inTargetType, outterTargetTable), outterInstCompTable.isTopLevel());
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        micq.setIncludeTargetTable(true);
        return micq;
    }

    public static MultiInstalledComponentQuery byComp(ComponentID inCompID) {
        if (inCompID == null) {
            throw new NullPointerException();
        }
        AndExp instComps = QueryBuilder.and(outterInstCompTable.equalsComp(inCompID), outterInstCompTable.rootIsReachable());
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        return micq;
    }

    public static MultiInstalledComponentQuery byTopLevelComp(ComponentID inCompID) {
        if (inCompID == null) {
            throw new NullPointerException();
        }
        AndExp instComps = QueryBuilder.and(outterInstCompTable.equalsComp(inCompID), outterInstCompTable.isTopLevel());
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_DESC);
        return micq;
    }

    public static MultiInstalledComponentQuery byParentContainer(InstalledComponentID parentID) {
        if (parentID == null) {
            throw new NullPointerException();
        }
        ConditionalExpression instComps = outterInstCompTable.equalsParentContainer(parentID);
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_ASC);
        return micq;
    }

    public static MultiInstalledComponentQuery byRootContainer(InstalledComponentID rootID) {
        if (rootID == null) {
            throw new NullPointerException();
        }
        AndExp instComps = QueryBuilder.and(outterInstCompTable.equalsRootContainer(rootID), outterInstCompTable.rootIsReachable());
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(instComps);
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_ASC);
        return micq;
    }

    static MultiInstalledComponentQuery byIDs(InstalledComponentID[] IDs) {
        MultiInstalledComponentQuery micq = new MultiInstalledComponentQuery(InstalledComponentSQLOps.emptyIn(MultiInstalledComponentQuery.outterInstCompTable.ID, InstalledComponentSQLOps.rList(IDs)));
        micq.setObjectOrder(InstalledComponentOrder.BY_DATE_ASC);
        micq.setInstalledFilter(null);
        return micq;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID filter) {
        this.mCategoryFilter = filter;
    }

    public Boolean getInstalledFilter() {
        return this.mInstalledFilter;
    }

    public void setInstalledFilter(Boolean filter) {
        this.mInstalledFilter = filter;
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    public InstalledComponentBean[] select() throws RPCException, PersistenceManagerException {
        BeanProcessor resultProcessor = new BeanProcessor(outterInstCompTable, outterCompTable, outterPlanTable, outterUserTable, outterGenVarsTable, outterTargetTable, outterHostTable, this.getRetrieveCreatedTarget());
        return (InstalledComponentBean[])this.select(resultProcessor, InstalledComponentBean.class);
    }

    private Object[] select(ResultProcessor resultProcessor, Class resultType) throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        Select query = this.getSelectStatement(resultProcessor);
        Object[] result = this.selectArray(query, resultProcessor, resultType);
        if (Logger.isInfoEnabled(this)) {
            String msg = ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"InstalledComponentQuery", new Long(System.currentTimeMillis() - time)});
            Logger.info(msg, this);
        }
        return result;
    }

    public InstalledComponent[] selectICView() throws RPCException, PersistenceManagerException {
        InstalledComponentProcessor resultProcessor = new InstalledComponentProcessor(outterInstCompTable, false);
        return (InstalledComponent[])this.select(resultProcessor, InstalledComponent.class);
    }

    private MultiInstalledComponentQuery(ConditionalExpression cond) {
        super(InstalledComponentOrder.FACTORY);
        this.mQueryConditional = cond;
    }

    protected TableList getTableList() {
        if (this.getRetrieveCreatedTarget()) {
            return QueryBuilder.tList(QueryBuilder.leftOuterJoin(outterInstCompTable, outterHostTable, QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterHostTable.InstalledComponentID, MultiInstalledComponentQuery.outterInstCompTable.ID)));
        }
        return QueryBuilder.tList(outterInstCompTable);
    }

    protected SelectList getSelectList() {
        if (this.getRetrieveCreatedTarget()) {
            return QueryBuilder.sList((SelectList)outterInstCompTable.allColumns(), (ScalarExp)MultiInstalledComponentQuery.outterHostTable.ID);
        }
        return outterInstCompTable.allColumns();
    }

    protected ConditionalExpression getWhereCondition() {
        return this.mQueryConditional;
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        Object clientContext = ctx.getClientContext();
        if (clientContext != null && clientContext instanceof BeanProcessor) {
            ((BeanProcessor)clientContext).addJoinConditions(ctx);
        }
        if (this.getIncludeCompTable()) {
            MultiInstalledComponentQuery.joinCompTable(ctx);
        }
        if (this.getIncludeTargetTable()) {
            MultiInstalledComponentQuery.joinTargetTable(ctx);
        }
        if (null != this.getInstalledFilter()) {
            ConditionalExpression cond = outterInstCompTable.isInstalled();
            if (!this.getInstalledFilter().booleanValue()) {
                cond = QueryBuilder.not(cond);
            }
            ctx.addAndWhereCondition(cond);
        }
        if (this.getCategoryFilter() != null) {
            MultiInstalledComponentQuery.joinCompTable(ctx);
            ctx.addAndWhereCondition(ComponentToCategoryLinkTable.DEFAULT.matchesCategoryID(this.getCategoryFilter(), MultiInstalledComponentQuery.outterCompTable.ID));
        }
    }

    private static boolean addTable(QueryContext ctx, Table table) {
        Table existing = ctx.getTableOfType(table.getClass());
        if (existing == null || existing != table) {
            ctx.addTable(table);
            return true;
        }
        return false;
    }

    static void joinTargetTable(QueryContext ctx) {
        if (MultiInstalledComponentQuery.addTable(ctx, outterTargetTable)) {
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterInstCompTable.TargetID, MultiInstalledComponentQuery.outterTargetTable.ID));
        }
    }

    static void joinCompTable(QueryContext ctx) {
        if (MultiInstalledComponentQuery.addTable(ctx, outterCompTable)) {
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterInstCompTable.ComponentID, MultiInstalledComponentQuery.outterCompTable.ID));
        }
    }

    private void setIncludeCompTable(boolean include) {
        this.mIncludeCompTable = include;
    }

    private boolean getIncludeCompTable() {
        return this.mIncludeCompTable;
    }

    private void setIncludeTargetTable(boolean include) {
        this.mIncludeTargetTable = include;
    }

    private boolean getIncludeTargetTable() {
        return this.mIncludeTargetTable;
    }

    private boolean getRetrieveCreatedTarget() {
        return this.mRetrieveCreatedTarget;
    }

    public void setRetrieveCreatedTarget(boolean retrieveCreatedTarget) {
        this.mRetrieveCreatedTarget = retrieveCreatedTarget;
    }

    static class BeanProcessor
    extends ResultProcessor {
        PersistentInstalledComponentTable mInstCompTable;
        ComponentImplTable mCompTable;
        ExecutionPlanImplTable mPlanTable;
        PersistentUserDataTable mUserTable;
        PersistentVariableSettingsTable mGenVarsTable;
        TargetProcessor mTargetProcessor;
        HostImplTable mHostImplTable;
        boolean mCreatedTargetRetrieved = false;

        public BeanProcessor(PersistentInstalledComponentTable inInstCompTable, ComponentImplTable inCompTable, ExecutionPlanImplTable inPlanTable, PersistentUserDataTable inUserTable, PersistentVariableSettingsTable inGenVarsTable, TargetImplTable inTargetTable, HostImplTable inHostImplTable, boolean createdTargetRetrieved) {
            this.mInstCompTable = inInstCompTable;
            this.mCompTable = inCompTable;
            this.mPlanTable = inPlanTable;
            this.mUserTable = inUserTable;
            this.mGenVarsTable = inGenVarsTable;
            this.mTargetProcessor = new TargetProcessor(inTargetTable, false);
            this.mHostImplTable = inHostImplTable;
            this.mCreatedTargetRetrieved = createdTargetRetrieved;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            PersistentInstalledComponent pic = this.mInstCompTable.retrieveObject(inResultSet);
            InstalledComponent instComp = new InstalledComponent(pic);
            PersistentUserData theUser = this.mUserTable.retrieveObject(inResultSet);
            UserBean theUserBean = new UserBean(theUser.getUserID(), theUser.getUsername());
            SummaryExecutionPlan plan = SummaryExecutionPlan.createFromResultSet(this.mPlanTable, inResultSet);
            ExecutionPlanBean thePlanBean = new ExecutionPlanBean(plan);
            SummaryComponent comp = SummaryComponent.createFromResultSet(this.mCompTable, inResultSet);
            ComponentBean theCompBean = new ComponentBean(comp);
            GeneratedVariableSettings theGenVars = GeneratedVariableSettings.createFromResultSet(this.mGenVarsTable, inResultSet);
            HostID theCreatedTarget = null;
            if (this.mCreatedTargetRetrieved) {
                theCreatedTarget = (HostID)this.mHostImplTable.ID.retrieveValue(inResultSet);
            }
            PersistentBean target = (PersistentBean)this.mTargetProcessor.processRow(inResultSet);
            this.mTargetProcessor.addResult(target);
            InstalledComponentBean theBean = new InstalledComponentBean(instComp, theUserBean, thePlanBean, theCompBean, theGenVars, theCreatedTarget, this.mCreatedTargetRetrieved);
            theBean.setIsPreflight(false);
            return theBean;
        }

        public Vector getResults() throws PersistenceManagerException {
            Vector targets = this.mTargetProcessor.getResults();
            HashMap<TargetID, Target> targetMap = new HashMap<TargetID, Target>();
            for (int i = 0; i < targets.size(); ++i) {
                Target t = (Target)targets.get(i);
                targetMap.put(t.getID(), t);
            }
            Vector results = super.getResults();
            for (int i = 0; i < results.size(); ++i) {
                InstalledComponentBean bean = (InstalledComponentBean)results.get(i);
                Target target = (Target)targetMap.get(bean.getTargetID());
                bean.setTarget(target);
            }
            return results;
        }

        void addJoinConditions(QueryContext ctx) {
            MultiInstalledComponentQuery.joinCompTable(ctx);
            MultiInstalledComponentQuery.joinTargetTable(ctx);
            this.addJoinTables(ctx);
            this.addJoinSelectLists(ctx);
            this.addJoinWhereConditions(ctx);
        }

        private void addJoinTables(QueryContext ctx) {
            ctx.addTable(outterUserTable);
            ctx.addTable(outterTaskInfoTable);
            ctx.addTable(outterPlanTable);
            ctx.addTable(outterGenVarsTable);
        }

        private void addJoinSelectLists(QueryContext ctx) {
            ctx.addAllColumnsToSelectList(outterCompTable);
            ctx.addAllColumnsToSelectList(outterUserTable);
            ctx.addAllColumnsToSelectList(outterPlanTable);
            ctx.addAllColumnsToSelectList(outterGenVarsTable);
            ctx.addAllColumnsToSelectList(outterTargetTable);
        }

        private void addJoinWhereConditions(QueryContext ctx) {
            QB;
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterInstCompTable.TaskID, MultiInstalledComponentQuery.outterTaskInfoTable.ID));
            QB;
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterTaskInfoTable.RoxUser, MultiInstalledComponentQuery.outterUserTable.ID));
            QB;
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterInstCompTable.PlanID, MultiInstalledComponentQuery.outterPlanTable.ID));
            QB;
            ctx.addAndWhereCondition(QueryBuilder.equals((ColumnNode)MultiInstalledComponentQuery.outterInstCompTable.VariableSettingsID, MultiInstalledComponentQuery.outterGenVarsTable.ID));
        }
    }
}

