/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyBeanProcessor;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyID;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencySQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;

public class MultiDependencyQuery
extends MultiObjectQueryImpl {
    private static final DependencySQLOps TABLE = new DependencySQLOps("depT");
    String mNameFilter;

    public static MultiDependencyQuery byDependenciesCreatedBy(InstalledComponentID dependantComponentID) {
        MultiDependencyQuery result = new MultiDependencyQuery(TABLE.isDependantInstallComponentID(dependantComponentID));
        result.setObjectOrder(DependencyOrder.BY_NAME_ASC);
        return result;
    }

    public static MultiDependencyQuery byDependantsOf(InstalledComponentID dependeeComponentID) {
        MultiDependencyQuery result = new MultiDependencyQuery(TABLE.isDependeeInstallComponentID(dependeeComponentID));
        result.setObjectOrder(DependencyOrder.BY_NAME_ASC);
        return result;
    }

    static MultiDependencyQuery byDependenciesCreatedBy(InstalledComponentID[] dependantComponentIDs) {
        MultiDependencyQuery result = new MultiDependencyQuery(TABLE.isDependantInstallComponentIDs(dependantComponentIDs));
        result.setObjectOrder(DependencyOrder.BY_NAME_ASC);
        return result;
    }

    static MultiDependencyQuery byDependantsOf(InstalledComponentID[] dependeeComponentIDs) {
        MultiDependencyQuery result = new MultiDependencyQuery(TABLE.isDependeeInstallComponentIDs(dependeeComponentIDs));
        result.setObjectOrder(DependencyOrder.BY_NAME_ASC);
        return result;
    }

    private MultiDependencyQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, DependencyOrder.FACTORY);
    }

    public String getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((DependencyOrder)order);
    }

    public Dependency[] select() throws RPCException, PersistenceManagerException {
        return (Dependency[])this.select(new DependencyBeanProcessor(this.getTable(), false), Dependency.class);
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        DependencySQLOps t = (DependencySQLOps)this.getTable();
        if (this.getNameFilter() != null) {
            ctx.addAndWhereCondition(t.equalsName(this.getNameFilter()));
        }
    }

    static MultiDependencyQuery byIDs(DependencyID[] ids) {
        MultiDependencyQuery result = new MultiDependencyQuery(ids);
        return result;
    }

    private MultiDependencyQuery(DependencyID[] IDs) {
        super((Table)TABLE, IDs, DependencyOrder.FACTORY);
    }
}

