/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.query.MultiEventQuery;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.SingleInstalledResourceQuery;
import com.raplix.util.logger.Logger;

public class InstalledResourceID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private InstalledResourceID() {
    }

    public InstalledResourceID(String sID) {
        super(sID);
    }

    public static InstalledResourceID generateInstalledResourceID() {
        return (InstalledResourceID)ID_FACTORY.generateObjectID();
    }

    public SingleInstalledResourceQuery getByIDQuery() {
        return new SingleInstalledResourceQuery(this);
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Examining Installed Resource " + this.toString() + " for dependent objects", "persist.objectdeletion");
        }
        try {
            InstalledComponent ic = this.getByIDQuery().select().getInstalledComponentID().getByIDQuery().select();
            if (ic.isInstalled() && !inContext.objectWillBeDeletedAfter(ic.getID(), this)) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Installed component " + ic + " is still installed, this resource is in use", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{new InstalledComponentBean(ic.getID())});
            }
            MultiEventQuery eventQuery = MultiEventQuery.all();
            eventQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    ROXEventFactoryTable t = (ROXEventFactoryTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(ROXEventFactoryTable.equals(t.InstalledResourceID, InstalledResourceID.this.toString()));
                }
            });
            inDependentContainer.addAllDependentObjects(eventQuery.selectObjects());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        InstalledResourceIDSet idset = new InstalledResourceIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        super.deleteMS(context);
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new InstalledResourceID(inID);
        }
    }
}

