/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.DeleteSession;
import com.raplix.rolloutexpress.persist.DisableDeleteLocking;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.ScalarList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencySQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallStatus;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledCompToInstalledCompLinkTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;

class InstalledComponentSQLOps
extends PersistentInstalledComponentTable {
    public static final InstalledComponentSQLOps DEFAULT = new InstalledComponentSQLOps();
    private static final InstallStatus INSTALLED = com.raplix.rolloutexpress.systemmodel.installdb.InstallStatus.INSTALLED;
    private static final InstallStatus UNINSTALLED = com.raplix.rolloutexpress.systemmodel.installdb.InstallStatus.UNINSTALLED;

    public InstalledComponentSQLOps(String alias) {
        super(alias);
    }

    private InstalledComponentSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new InstalledComponentSQLOps(alias);
    }

    public ConditionalExpression equalsCompRef(HostID inHostID, TargetType inTargetType, InstalledComponentRef inCompRef, TaskID inTaskID, TargetSQLOps targetTable, ComponentImplTable compTable) throws PersistenceManagerException {
        inCompRef = inCompRef.toUniversal();
        FolderID componentPathID = inCompRef.getPath();
        String componentName = inCompRef.getComponentName();
        String installPath = inCompRef.getInstallPath();
        Comparator comp = inCompRef.getVersionComparator();
        AndExp installComps = InstalledComponentSQLOps.and(this.isTopLevel(), InstalledComponentSQLOps.and(InstalledComponentSQLOps.and(InstalledComponentSQLOps.equals(compTable.PathID, componentPathID), InstalledComponentSQLOps.equals(compTable.Name, componentName)), this.isOnHost(inHostID, inTargetType, targetTable)));
        if (inCompRef.getComponentVersion() != null) {
            int versionNumber = new VersionNumber(inCompRef.getComponentVersion()).getSingleVersionNumber();
            if (Comparator.GREATER_THAN.equals(comp)) {
                installComps.add(InstalledComponentSQLOps.greaterThan(compTable.Version, versionNumber));
            } else if (Comparator.EQUAL.equals(comp)) {
                installComps.add(InstalledComponentSQLOps.equals(compTable.Version, versionNumber));
            } else {
                installComps.add(InstalledComponentSQLOps.greaterEquals(compTable.Version, versionNumber));
            }
        }
        if (inTaskID != null) {
            installComps.add(InstalledComponentSQLOps.equals(this.TaskID, inTaskID));
        }
        if (installPath != null) {
            installComps.add(InstalledComponentSQLOps.equals(this.InstallPath, installPath));
        }
        return installComps;
    }

    public ConditionalExpression isInstanceOf(HostID hostID, TargetType targetType, String typeName, String installPath, TargetSQLOps targetTable, ComponentImplTable compTable) {
        AndExp installComps = InstalledComponentSQLOps.and(this.isTopLevel(), this.isOnHost(hostID, targetType, targetTable));
        installComps.add(this.isInstanceOf(typeName, compTable));
        if (installPath != null) {
            installPath = InstalledComponentRef.toUniversalPath(installPath);
            installComps.add(InstalledComponentSQLOps.equals(this.InstallPath, installPath));
        }
        return installComps;
    }

    public ConditionalExpression isInstanceOf(String typeName, ComponentImplTable compTable) {
        ComponentTypeRefImplTable itt = new ComponentTypeRefImplTable("itt");
        Select typeID = itt.select(InstalledComponentSQLOps.sList(itt.ID), InstalledComponentSQLOps.where(InstalledComponentSQLOps.equals(itt.Name, typeName)));
        CompTypeRefToCompTypeRefLinkTable tlt = CompTypeRefToCompTypeRefLinkTable.DEFAULT;
        Select derivedTypeIDs = tlt.selectChildIDs(typeID);
        ComponentTypeRefImplTable ott = new ComponentTypeRefImplTable("ott");
        Select derivedTypeNames = ott.select(InstalledComponentSQLOps.sList(ott.Name), InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)ott.ID, derivedTypeIDs)));
        return InstalledComponentSQLOps.or(InstalledComponentSQLOps.equals(compTable.ExtendsTypeName, typeName), InstalledComponentSQLOps.in((ColumnNode)compTable.ExtendsTypeName, derivedTypeNames));
    }

    public ConditionalExpression isOnHost(HostID inHostID, TargetType inTargetType, TargetSQLOps targetTable) {
        return targetTable.equalsHost(inHostID, inTargetType);
    }

    public ConditionalExpression isTopLevel() {
        return InstalledComponentSQLOps.isNull(this.ParentContainerID);
    }

    public ConditionalExpression rootIsReachable() {
        return InstalledComponentSQLOps.equals((ColumnNode)this.ReachableContainerID, this.RootContainerID);
    }

    public ConditionalExpression equalsComp(ComponentID compID) {
        return InstalledComponentSQLOps.equals(this.ComponentID, compID);
    }

    public ConditionalExpression equalsParentContainer(InstalledComponentID parentID) {
        return InstalledComponentSQLOps.equals(this.ParentContainerID, parentID);
    }

    public ConditionalExpression equalsParentContainer(InstalledComponentID parentID, String refName) {
        return InstalledComponentSQLOps.and(this.isInstalled(), InstalledComponentSQLOps.and(this.equalsParentContainer(parentID), InstalledComponentSQLOps.equals(this.ParentContainerRefName, refName)));
    }

    public ConditionalExpression equalsRootContainer(InstalledComponentID rootID) {
        return InstalledComponentSQLOps.equals(this.RootContainerID, rootID);
    }

    public ConditionalExpression isInstalled() {
        return InstalledComponentSQLOps.equals(this.InstallStatus, INSTALLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installComponent(final InstalledComponent inInstalledComp, final InstalledComponent previousInstalledComp, final Date installDate) throws PersistenceManagerException, RPCException {
        Host.acquireHostLock();
        final boolean reqHostRes = inInstalledComp.getTargetableHostReservationID() != null;
        try {
            PersistentInstalledComponent.retryOnDeadlock(new ReEntrantTransaction(){

                public Object execute() throws PersistenceManagerException {
                    PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object execute() throws PersistenceManagerException {
                            InstalledComponentSQLOps.access$500(1.access$400(this.this$1), 1.access$000(this.this$1), 1.access$100(this.this$1), 1.access$200(this.this$1), 1.access$300(this.this$1));
                            return null;
                        }
                    });
                    return null;
                }

                static /* synthetic */ InstalledComponent access$000(1 x0) {
                    return x0.inInstalledComp;
                }

                static /* synthetic */ InstalledComponent access$100(1 x0) {
                    return x0.previousInstalledComp;
                }

                static /* synthetic */ Date access$200(1 x0) {
                    return x0.installDate;
                }

                static /* synthetic */ boolean access$300(1 x0) {
                    return x0.reqHostRes;
                }

                static /* synthetic */ InstalledComponentSQLOps access$400(1 x0) {
                    return x0.InstalledComponentSQLOps.this;
                }
            });
        }
        finally {
            Host.releaseHostLock();
        }
    }

    private void installComponentTR(InstalledComponent inInstalledComp, InstalledComponent previousInstalledComp, Date installDate, boolean reqHostRes) throws PersistenceManagerException {
        SetList setList = InstalledComponentSQLOps.uList();
        setList.add(InstalledComponentSQLOps.set(this.InstallDate, installDate));
        setList.add(InstalledComponentSQLOps.set(this.UninstallDate, (Date)null));
        setList.add(InstalledComponentSQLOps.set(this.InstallStatus, INSTALLED));
        InstalledComponentSQLOps.execute(this.update(setList, InstalledComponentSQLOps.where(InstalledComponentSQLOps.equals(this.ID, inInstalledComp.getID()))));
        InstalledComponentIDSet reachableChildrenSet = new InstalledComponentIDSet();
        this.executeIDsResult(this.ID, InstalledComponentSQLOps.where(InstalledComponentSQLOps.and(InstalledComponentSQLOps.equals(this.ParentContainerID, inInstalledComp.getID()), this.isInstalled())), reachableChildrenSet);
        if (!reachableChildrenSet.isEmpty()) {
            ScalarList reachableChildren = InstalledComponentSQLOps.rList(reachableChildrenSet.toIDArray());
            setList = InstalledComponentSQLOps.uList(InstalledComponentSQLOps.set(this.ReachableContainerID, inInstalledComp.getID()));
            InstalledComponentSQLOps.execute(this.update(setList, InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)this.ReachableContainerID, reachableChildren))));
        }
        try {
            TargetRef tr;
            Component theComponent = inInstalledComp.getComponentID().getByIDQuery().select();
            TargetRef trcg = tr = theComponent.getTargetRef();
            if (null != tr) {
                ConfigGenSubsystem cgsys = HostDBSubsystem.getInstance().getApplication().getConfigGenSubsystem();
                ComponentConfigManager cg = cgsys.getConfigGenerator().newComponentManager(inInstalledComp.getVariableSettingsID());
                trcg = tr.generate(cg);
            }
            if (reqHostRes && inInstalledComp.getTargetableHostReservationID() == null) {
                HostReservationID newRes = PersistentInstallDBContext.reserveHostForTR(trcg, previousInstalledComp);
                inInstalledComp.setTargetableHostReservationID(newRes);
            }
            if (previousInstalledComp != null) {
                InstalledComponentSQLOps.execute(this.update(InstalledComponentSQLOps.uList(InstalledComponentSQLOps.set(this.UninstallDate, installDate), InstalledComponentSQLOps.set(this.InstallStatus, UNINSTALLED)), InstalledComponentSQLOps.where(InstalledComponentSQLOps.and(this.isInstalled(), InstalledComponentSQLOps.equals(this.RootContainerID, previousInstalledComp.getID())))));
                DependencySQLOps.DEFAULT.upgradeDependencies(previousInstalledComp.getID(), inInstalledComp.getID());
                this.deleteDependentObjectsCreatedByIncludingChildren(previousInstalledComp.getID());
                if (trcg != null) {
                    final Host previouslyInstalledHost = SingleHostQuery.byInstalledComponentID(previousInstalledComp.getID()).select();
                    previouslyInstalledHost.reinstallTargetableComponentHost(trcg, inInstalledComp.getID(), inInstalledComp.getTargetableHostReservationID());
                    inInstalledComp.setTargetableHostReservationID(null);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws RPCException, PersistenceManagerException {
                                previouslyInstalledHost.save();
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        this.processPrivilegedException(e);
                    }
                }
            } else if (trcg != null) {
                final Host h = new Host(trcg, inInstalledComp.getID(), inInstalledComp.getTargetableHostReservationID());
                inInstalledComp.setTargetableHostReservationID(null);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws RPCException, PersistenceManagerException {
                            h.save();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    this.processPrivilegedException(e);
                }
            }
        }
        catch (TransportException e) {
            throw new PersistenceManagerException(e);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new PersistenceManagerException(e);
        }
        catch (ConfigGenException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private void processPrivilegedException(PrivilegedActionException e) throws RPCException, PersistenceManagerException {
        if (e.getException() instanceof RPCException) {
            throw (RPCException)e.getException();
        }
        if (e.getException() instanceof PersistenceManagerException) {
            throw (PersistenceManagerException)e.getException();
        }
        throw new PersistenceManagerException(e.getException());
    }

    public void uninstallComponent(final InstalledComponent inInstalledComp, final Date uninstallDate, final InstalledComponentID uninstaller) throws PersistenceManagerException {
        PersistentInstalledComponent.retryOnDeadlock(new ReEntrantTransaction(){

            public Object execute() throws PersistenceManagerException {
                PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object execute() throws PersistenceManagerException {
                        InstalledComponentSQLOps.access$1000(5.access$900(this.this$1), 5.access$600(this.this$1), 5.access$700(this.this$1), 5.access$800(this.this$1));
                        return null;
                    }
                });
                return null;
            }

            static /* synthetic */ InstalledComponent access$600(5 x0) {
                return x0.inInstalledComp;
            }

            static /* synthetic */ Date access$700(5 x0) {
                return x0.uninstallDate;
            }

            static /* synthetic */ InstalledComponentID access$800(5 x0) {
                return x0.uninstaller;
            }

            static /* synthetic */ InstalledComponentSQLOps access$900(5 x0) {
                return x0.InstalledComponentSQLOps.this;
            }
        });
    }

    private void uninstallComponentTR(InstalledComponent inInstalledComp, Date uninstallDate, InstalledComponentID uninstaller) throws PersistenceManagerException {
        InstalledComponentID iCompID = inInstalledComp.getID();
        SetList setList = InstalledComponentSQLOps.uList(InstalledComponentSQLOps.set(this.UninstallDate, uninstallDate), InstalledComponentSQLOps.set(this.InstallStatus, UNINSTALLED));
        ObjectID[] descendants = this.childrenOf(iCompID);
        WhereClause where = InstalledComponentSQLOps.where(InstalledComponentSQLOps.and(this.isInstalled(), InstalledComponentSQLOps.in((ColumnNode)this.ID, InstalledComponentSQLOps.rList(descendants))));
        InstalledComponentSQLOps.execute(this.update(setList, where));
        this.deleteDependentObjectsCreatedByIncludingChildren(iCompID, uninstaller, (InstalledComponentID[])descendants);
        try {
            final SummaryHost trHost = SingleHostQuery.byInstalledComponentID(inInstalledComp.getID()).selectSummaryView();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RPCException, PersistenceManagerException {
                        try {
                            DeleteSession.executeDeleteLocksDisabled(new DisableDeleteLocking(this){
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public Object run() throws Exception {
                                    7.access$1100(this.this$1).getID().delete();
                                    return null;
                                }
                            });
                        }
                        catch (RPCException e) {
                            throw e;
                        }
                        catch (PersistenceManagerException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new PersistenceManagerException(e);
                        }
                        return null;
                    }

                    static /* synthetic */ SummaryHost access$1100(7 x0) {
                        return x0.trHost;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.processPrivilegedException(e);
            }
        }
        catch (NoResultsFoundException e) {
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private InstalledComponentID[] childrenOf(InstalledComponentID parentID) throws PersistenceManagerException {
        InstalledComponentIDSet set = new InstalledComponentIDSet();
        set.add(parentID);
        InstalledCompToInstalledCompLinkTable linkTab = InstalledCompToInstalledCompLinkTable.DEFAULT;
        linkTab.getByParentID(parentID, set);
        return set.toIDArray();
    }

    private void deleteDependentObjectsCreatedByIncludingChildren(InstalledComponentID id) throws PersistenceManagerException {
        this.deleteDependentObjectsCreatedByIncludingChildren(id, null, this.childrenOf(id));
    }

    private void deleteDependentObjectsCreatedByIncludingChildren(InstalledComponentID id, InstalledComponentID uninstaller, InstalledComponentID[] descendants) throws PersistenceManagerException {
        this.deleteResourcesInstalledBy(descendants);
        this.deleteDependencies(id, uninstaller, descendants);
    }

    private void deleteDependencies(InstalledComponentID id, InstalledComponentID uninstaller, InstalledComponentID[] descendants) throws PersistenceManagerException {
        DependencySQLOps depOps = DependencySQLOps.DEFAULT;
        OrExp dependencies = InstalledComponentSQLOps.or();
        dependencies.add(InstalledComponentSQLOps.in((ColumnNode)depOps.DependantInstalledComponentID, InstalledComponentSQLOps.rList(descendants)));
        if (uninstaller != null) {
            AndExp uninstallerDep = InstalledComponentSQLOps.and(InstalledComponentSQLOps.equals(depOps.DependeeInstalledComponentID, id), InstalledComponentSQLOps.equals(depOps.DependantInstalledComponentID, uninstaller));
            dependencies.add((ConditionalExpression)uninstallerDep);
        }
        Select s = depOps.select(InstalledComponentSQLOps.sList(depOps.cID()), InstalledComponentSQLOps.where(dependencies));
        DependencyToComponentNameRefTable dtcnr = DependencyToComponentNameRefTable.DEFAULT;
        InstalledComponentSQLOps.execute(dtcnr.delete(InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)dtcnr.cParentID(), s))));
        InstalledComponentSQLOps.execute(InstalledComponentSQLOps.delete(depOps, InstalledComponentSQLOps.where(dependencies)));
    }

    private void deleteResourcesInstalledBy(InstalledComponentID[] comps) throws PersistenceManagerException {
        PersistentInstalledResourceTable resTable = PersistentInstalledResourceTable.DEFAULT;
        ROXEventFactoryTable eventTable = ROXEventFactoryTable.DEFAULT;
        WhereClause installedResources = InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)resTable.InstalledComponentID, InstalledComponentSQLOps.rList(comps)));
        InstalledResourceIDSet rsrcIDSet = new InstalledResourceIDSet();
        resTable.executeIDsResult(resTable.ID, installedResources, rsrcIDSet);
        if (!rsrcIDSet.isEmpty()) {
            ScalarList targets = InstalledComponentSQLOps.rList(rsrcIDSet.toIDArray());
            InstalledComponentSQLOps.execute(InstalledComponentSQLOps.delete(eventTable, InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)eventTable.InstalledResourceID, targets))));
            InstalledComponentSQLOps.execute(InstalledComponentSQLOps.delete(resTable, InstalledComponentSQLOps.where(InstalledComponentSQLOps.in((ColumnNode)resTable.ID, targets))));
        }
    }

    static /* synthetic */ void access$500(InstalledComponentSQLOps x0, InstalledComponent x1, InstalledComponent x2, Date x3, boolean x4) throws PersistenceManagerException {
        x0.installComponentTR(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1000(InstalledComponentSQLOps x0, InstalledComponent x1, Date x2, InstalledComponentID x3) throws PersistenceManagerException {
        x0.uninstallComponentTR(x1, x2, x3);
    }
}

