/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.query.MultiEventQuery;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencySQLOps;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledCompToInstalledCompLinkTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiDependencyQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledResourceQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiSnapshotQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import com.raplix.rolloutexpress.systemmodel.installdb.SingleInstalledComponentQuery;
import com.raplix.util.logger.Logger;

public class InstalledComponentID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private InstalledComponentID() {
    }

    public InstalledComponentID(String sID) {
        super(sID);
    }

    public MultiSnapshotQuery getSnapshotsQuery() {
        return MultiSnapshotQuery.byInstaller(this);
    }

    public SingleInstalledComponentQuery getByIDQuery() {
        return new SingleInstalledComponentQuery(this);
    }

    public static InstalledComponentID generateInstalledComponentID() {
        return (InstalledComponentID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Examining Installed Component " + this.toString() + " for dependent objects", "persist.objectdeletion");
        }
        try {
            InstalledComponent ic = this.getByIDQuery().select();
            if (ic != null) {
                boolean deletingThisTarget;
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Checking to see if the owning target of this installed component is going to be deleted", "persist.objectdeletion");
                }
                if (!(deletingThisTarget = inContext.objectWillBeDeletedAfter(ic.getTargetID(), this)) && ic.isInstalled()) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("The ic is installed and the owning target is not going to be deleted, so this Installed Component is in use", "persist.objectdeletion");
                    }
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{new InstalledComponentBean(ic.getRootContainerID())});
                }
                UsingObject[] dependents = MultiDependencyQuery.byDependantsOf(this).select();
                if (dependents.length > 0) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("The ic is a dependency of another object, so it is in use", "persist.objectdeletion");
                    }
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), dependents);
                }
                MultiDifferenceSettingsQuery diffQuery = MultiDifferenceSettingsQuery.all();
                diffQuery.addFilter(new ObjectFilter(){

                    public void addFilterCondition(QueryContext ctx) {
                        DifferenceSettingsTable t = (DifferenceSettingsTable)ctx.getFirstTable();
                        ctx.addAndWhereCondition(DifferenceSettingsTable.equals(t.InstalledComponentID, InstalledComponentID.this));
                    }
                });
                UsingObject[] objs = (UsingObject[])diffQuery.selectObjects();
                if (objs.length > 0) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("The ic is in use by a difference settings object", "persist.objectdeletion");
                    }
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), objs);
                }
            }
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("The ic is not in use, now collecting dependent objects", "persist.objectdeletion");
            }
            MultiInstalledResourceQuery resourceQuery = MultiInstalledResourceQuery.all();
            resourceQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    PersistentInstalledResourceTable t = (PersistentInstalledResourceTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(PersistentInstalledResourceTable.equals(t.InstalledComponentID, InstalledComponentID.this));
                }
            });
            resourceQuery.setInstalledFilter(null);
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Adding dependent resources of the installed component", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(resourceQuery.selectObjects());
            MultiSnapshotQuery msq = this.getSnapshotsQuery();
            msq.setStatusFilter(null);
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Adding dependent snapshots of the installed component", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(msq.selectObjects());
            MultiEventQuery eventQuery = MultiEventQuery.all();
            eventQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    ROXEventFactoryTable t = (ROXEventFactoryTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(ROXEventFactoryTable.equals(t.InstalledComponentID, InstalledComponentID.this.toString()));
                }
            });
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Adding dependent events of the installed component", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(eventQuery.selectObjects());
            MultiInstalledComponentQuery compQuery = MultiInstalledComponentQuery.byParentContainer(this);
            compQuery.setInstalledFilter(null);
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Adding dependent installed components of the installed component", "persist.objectdeletion");
            }
            inDependentContainer.addAllDependentObjects(compQuery.selectObjects());
            if (null != ic && null != ic.getVariableSettingsID()) {
                inPostDependentContainer.addDependentObject(ic.getVariableSettingsID().getByIDQuery().select());
            }
            try {
                inDependentContainer.addDependentObject(SingleHostQuery.byInstalledComponentID(this).selectSummaryView());
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Adding dependent targetable host of the installed component", "persist.objectdeletion");
                }
            }
            catch (NoResultsFoundException e) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("No dependent targetable host for this installed component", "persist.objectdeletion");
                }
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        InstalledComponentIDSet idset = new InstalledComponentIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        InstalledCompToInstalledCompLinkTable.DEFAULT.removeByChildID(this);
        DependencySQLOps.DEFAULT.removeDependencies(this);
        super.deleteMS(context);
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new InstalledComponentID(inID);
        }
    }
}

