/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostReservationID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import java.util.Date;

public class InstalledComponent
implements RPCSerializable {
    private PersistentInstalledComponent mData;
    private transient HostReservationID mHostReservationID;

    private InstalledComponent() {
    }

    public InstalledComponent(PersistentInstalledComponent data) {
        this.setData(data);
    }

    public InstalledComponentID getID() {
        return this.getData().getID();
    }

    public ComponentID getComponentID() {
        return this.getData().getComponentID();
    }

    public String getInstallPath() {
        return this.getData().getInstallPath();
    }

    public InstalledComponentID getParentContainerID() {
        return this.getData().getParentContainerID();
    }

    public String getParentContainerRefName() {
        return this.getData().getParentContainerRefName();
    }

    public InstalledComponentID getRootContainerID() {
        return this.getData().getRootContainerID();
    }

    public TargetID getTargetID() {
        return this.getData().getTargetID();
    }

    public GeneratedVariableSettingsID getVariableSettingsID() {
        return this.getData().getVariableSettingsID();
    }

    public TaskID getTaskID() {
        return this.getData().getTaskID();
    }

    public ExecutionPlanID getPlanID() {
        return this.getData().getPlanID();
    }

    public Date getInstallDate() {
        return this.getData().getInstallDate();
    }

    public Date getUninstallDate() {
        return this.getData().getUninstallDate();
    }

    public String getInstallBlockName() {
        return this.getData().getInstallBlockName();
    }

    public boolean isInstalled() {
        return this.getInstallDate() != null && this.getUninstallDate() == null && this.getData().getReachableContainerID() != null && this.getData().getReachableContainerID().equals(this.getRootContainerID());
    }

    public boolean equalsData(InstalledComponent other) {
        return this.getData().equalsData(other.getData());
    }

    PersistentInstalledComponent getData() {
        return this.mData;
    }

    private void setData(PersistentInstalledComponent data) {
        this.mData = data;
    }

    public String toString() {
        return this.getData().toString();
    }

    void setTargetableHostReservationID(HostReservationID inHostReservationID) {
        this.mHostReservationID = inHostReservationID;
    }

    HostReservationID getTargetableHostReservationID() {
        return this.mHostReservationID;
    }
}

