/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import [Lcom.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.ROXResourceInstallEvent;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledResourceRef;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.installdb.Messages;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import com.raplix.util.collections.CollectionUtil;
import java.util.Vector;

public class InstallDBSubsystem
extends Subsystem
implements InstallDBManager,
Messages {
    public InstallDBSubsystem(Application app) throws ConfigurationException {
        super(app);
    }

    private InstallDBSubsystem() {
    }

    public void registerRPCInterfaces(RPCManager rpc) throws RPCException {
        rpc.registerService(InstallDBManager.class, this);
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("installdb.SUBSYSTEM_NAME");
    }

    public InstalledResource createInstalledResource(InstalledComponentID installedComponentID, ResourceID resourceID, String installPath) throws InstallDBException {
        try {
            PersistentInstalledResource pic = new PersistentInstalledResource(installedComponentID, resourceID, installPath);
            pic.save();
            return new InstalledResource(pic);
        }
        catch (PersistenceManagerException pmex) {
            throw InstallDBException.saveError(pmex);
        }
    }

    public InstalledResource createTempInstalledResource(InstalledComponentID installedComponentID, ResourceID resourceID, String installPath) {
        PersistentInstalledResource pic = new PersistentInstalledResource(installedComponentID, resourceID, installPath);
        return new InstalledResource(pic);
    }

    public InstalledResource getInstalledResource(InstalledResourceID ID2) throws InstallDBException, NoResultsFoundException {
        return new InstalledResource(new PersistentInstalledResource(ID2));
    }

    public InstalledResource[] queryResourcesInstalledBy(InstalledComponentID installedComponentID) throws InstallDBException {
        PersistentInstalledResourceTable ir = new PersistentInstalledResourceTable("ir");
        ROXEventFactoryTable e = new ROXEventFactoryTable("e");
        try {
            SelectList selectList = PersistentInstalledResourceTable.sList((SelectList)ir.allColumns(), e.allColumns());
            TableList tableList = PersistentInstalledResourceTable.tList(ir, (TableClause)e);
            String installEventName = ROXResourceInstallEvent.class.getName();
            WhereClause whereClause = PersistentInstalledResourceTable.where(PersistentInstalledResourceTable.and(PersistentInstalledResourceTable.equals(ir.InstalledComponentID, installedComponentID), PersistentInstalledResourceTable.and(PersistentInstalledResourceTable.equals(e.EventType, installEventName), PersistentInstalledResourceTable.equals((ColumnNode)ir.ID, e.InstalledResourceID))));
            Select query = PersistentInstalledResourceTable.select(selectList, tableList, whereClause, PersistentInstalledResourceTable.oList(PersistentInstalledResourceTable.orderByAsc(e.Date)));
            PersistentBean[] pirs = PersistentInstalledResourceTable.executeMultiResult(query, ir);
            InstalledResource[] result = new InstalledResource[pirs.length];
            for (int i = 0; i < pirs.length; ++i) {
                PersistentInstalledResource pir = (PersistentInstalledResource)pirs[i];
                result[i] = new InstalledResource(pir);
            }
            return result;
        }
        catch (PersistenceManagerException pme) {
            throw InstallDBException.retrieveError(pme);
        }
    }

    public InstalledResource[] queryResourcesInstalledBy(InstalledComponentID installedComponentID, InstalledResourceRef installedResourceRef) throws InstallDBException {
        InstalledResource[] r = this.queryResourcesInstalledBy(installedComponentID);
        Vector<InstalledResource> result = new Vector<InstalledResource>();
        for (int i = 0; i < r.length; ++i) {
            if (installedResourceRef.getResourceID() != null && !installedResourceRef.getResourceID().equals(r[i].getResourceID()) || installedResourceRef.getInstallPath() != null && !installedResourceRef.getInstallPath().equals(r[i].getInstallPath())) continue;
            result.add(r[i]);
        }
        return (InstalledResource[])CollectionUtil.mapClass(result, InstalledResource;.class);
    }
}

