/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.Messages;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;

public class InstallDBException
extends CommandException
implements Messages {
    protected InstallDBException() {
    }

    public InstallDBException(ROXMessage msg, Throwable t) {
        super(msg, t);
    }

    public InstallDBException(ROXMessage msg) {
        super(msg);
    }

    public InstallDBException(Throwable t) {
        super(t);
    }

    public static InstallDBException retrieveError(Throwable t) {
        return InstallDBException.newSystemError("installdb.RETR_ERR", t);
    }

    public static InstallDBException saveError(Throwable t) {
        return InstallDBException.newSystemError("installdb.SAVE_ERR", t);
    }

    static InstallDBException dependencyCannotUseBulkTargeter(InstalledComponentTargeter targeter) {
        return new InstallDBException(new ROXMessage("installdb.DEPENDENCY_CANNOT_USE_BULK_TARGETER", new String[]{((Object)targeter).toString()}));
    }

    public static InstallDBException invalidInstallPath(ComponentID inCompID) {
        String compName = "";
        try {
            compName = inCompID.getByIDQuery().selectSummaryView().getFullName();
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return InstallDBException.newValidationError("installdb.EMPTY_INSTALL_PATH_FOR_COMPONENT", compName);
    }

    static InstallDBException targetableCompTypeChanged() {
        return InstallDBException.newValidationError("installdb.COMP_TYPES_CHANGED");
    }

    static InstallDBException targetableTRTypeChanged() {
        return InstallDBException.newValidationError("installdb.TR_COMP_TYPES_CHANGED");
    }

    static InstallDBException targetableTRAddressChanged() {
        return InstallDBException.newValidationError("installdb.TR_ADDRESSES_CHANGED");
    }

    static InstallDBException cantUninstallTargetableHostWithInstalledComps() {
        return InstallDBException.newValidationError("installdb.CANT_UNINSTALL_TR_HOST_WITH_COMPS");
    }

    private static InstallDBException newSystemError(String code, Throwable t) {
        return new InstallDBException(new ROXMessage(code), t);
    }

    private static InstallDBException newSystemError(String code, String arg) {
        return new InstallDBException(new ROXMessage(code, new String[]{arg}));
    }

    private static InstallDBException newSystemError(String code) {
        return new InstallDBException(new ROXMessage(code));
    }

    private static InstallDBException newValidationError(String code, String arg) {
        return InstallDBException.newValidationError(code, new String[]{arg});
    }

    private static InstallDBException newValidationError(String code) {
        return InstallDBException.newValidationError(code, new String[0]);
    }

    private static InstallDBException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new InstallDBException(msg);
    }
}

