/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyCheckInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyViolationException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.util.logger.Logger;

public abstract class InstallDBContextBase {
    protected InstalledComponent newInstalledComponent(ComponentID componentID, String installPath, InstalledComponent parentContainer, String parentContainerRefName, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName) throws InstallDBException {
        installPath = InstalledComponentRef.toUniversalPath(installPath);
        PersistentInstalledComponent pic = new PersistentInstalledComponent(componentID, installPath, parentContainer, parentContainerRefName, targetID, varSettingsID, taskID, planID, installBlockName);
        return new InstalledComponent(pic);
    }

    protected InstalledComponent isUpgrade(InstalledComponent newInstalledComp, TargetedConfigContext ctx, Caller caller) throws InstallDBException, PersistenceManagerException, RPCException {
        if (newInstalledComp.getParentContainerID() != null) {
            return null;
        }
        SummaryComponent theComp = newInstalledComp.getComponentID().getByIDQuery().selectSummaryView();
        InstalledComponentRef compRef = new InstalledComponentRef(theComp.getPath(), theComp.getName(), null, null, false, newInstalledComp.getInstallPath(), true);
        HostID currentHost = newInstalledComp.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID();
        InstalledComponent previousInstalledComp = this.getInstalledComponent(currentHost, compRef);
        return previousInstalledComp;
    }

    public abstract InstalledComponent getInstalledComponent(HostID var1, InstalledComponentRef var2, TargetType var3) throws PersistenceManagerException, RPCException;

    public abstract Dependency[] queryDependantsOf(InstalledComponentID var1, String var2) throws RPCException, PersistenceManagerException;

    public synchronized void canUninstallComponent(InstalledComponent ic, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        Dependency[] depsArray = this.queryDependantsOf(ic.getID(), null);
        if (depsArray.length > 0) {
            InstalledComponentID uninstallerID = this.getUninstallerID(caller);
            for (int i = 0; i < depsArray.length; ++i) {
                InstalledComponentID dependantID = depsArray[i].getDependantInstalledComponentID();
                if (dependantID.equals(uninstallerID)) continue;
                throw DependencyViolationException.cannotUninstallComponentWithDependants(ic);
            }
        }
        this.validateTargetableComponentUninstallation(ic.getComponentID().getByIDQuery().select(), ic);
    }

    protected void validateTargetableComponentUninstallation(Component inComponent, InstalledComponent inIC) throws InstallDBException, RPCException, PersistenceManagerException {
        SummaryHost targetableHost;
        block8: {
            if (inComponent.getLocalTargetRef() == null) {
                return;
            }
            targetableHost = null;
            try {
                targetableHost = SingleHostQuery.byInstalledComponentID(inIC.getID()).selectSummaryView();
            }
            catch (NoResultsFoundException e) {
                if (!Logger.isDebugEnabled(this)) break block8;
                Logger.debug("No targetable host found for hostname: " + inComponent.getTargetRef().getHostName(), this);
            }
        }
        if (targetableHost != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Searching for installed components on " + targetableHost.getName(), this);
            }
            if (this.searchForInstalledComps(targetableHost)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Installed component(s) found on host " + targetableHost.getName() + " - this is not allowed!", this);
                }
                throw InstallDBException.cantUninstallTargetableHostWithInstalledComps();
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("No targetable components found on host " + targetableHost.getName() + " - this host may be removed", this);
            }
        }
    }

    protected boolean searchForInstalledComps(SummaryHost inHost) throws RPCException, PersistenceManagerException {
        return MultiInstalledComponentQuery.byHost(inHost.getID(), TargetType.CURRENT).selectExists();
    }

    InstalledComponentID getUninstallerID(Caller caller) {
        InstalledComponent uninstaller = caller == null ? null : caller.getInstalledComponent();
        return uninstaller == null ? null : uninstaller.getID();
    }

    public synchronized InstalledComponent getInstalledComponent(HostID hostID, InstalledComponentRef compRef) throws PersistenceManagerException, RPCException {
        return this.getInstalledComponent(hostID, compRef, TargetType.CURRENT);
    }

    public InstalledComponent getInstalledComponent(InstalledComponentID inID) throws RPCException, PersistenceManagerException {
        return inID.getByIDQuery().select();
    }

    protected void validateDependencyTarget(Caller caller, InstalledComponentTargeter inDependencyTargeter, TargetedConfigContext ctx) throws DependencyViolationException, InstallDBException, RPCException, PersistenceManagerException {
        Dependency.resolveDependency(inDependencyTargeter, ctx, caller, (InstallDBContext)((Object)this));
        InstalledComponent newParentVersion = this.getInstalledComponent(caller.getInstalledComponent().getRootContainerID());
        DependencyCheckInstallDBContext theContext = new DependencyCheckInstallDBContext(caller.getInstalledComponent().getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID(), newParentVersion, (InstallDBContext)((Object)this));
        try {
            Dependency.resolveDependency(inDependencyTargeter, ctx, caller, theContext);
        }
        catch (DependencyViolationException e) {
            throw DependencyViolationException.cannotCreateDependencyOnCompBeingUpgraded(((Object)inDependencyTargeter).toString());
        }
    }

    static boolean shouldCheckCallCompatibility(InstalledComponentRef compRef) {
        return compRef.getOnlyCallCompatible() && compRef.getComponentVersion() != null && !Comparator.EQUAL.equals(compRef.getVersionComparator());
    }

    protected void validateReinstall(Component inComponent, InstalledComponent inCurrentInstalledComponent, InstalledComponent inPreviousInstalledComponent) throws InstallDBException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing reinstall validation of " + inComponent.getName(), this);
        }
        try {
            TargetRef currentTR = null;
            if (inComponent != null) {
                currentTR = inComponent.getTargetRef();
            }
            TargetRef previousTR = inPreviousInstalledComponent.getComponentID().getByIDQuery().select().getTargetRef();
            if (currentTR == null && previousTR != null || currentTR != null && previousTR == null) {
                throw InstallDBException.targetableCompTypeChanged();
            }
            if (currentTR != null) {
                if (currentTR.isVirtual() != previousTR.isVirtual()) {
                    throw InstallDBException.targetableTRTypeChanged();
                }
                TargetRef cgCurrentTR = this.cgTargetRef(inCurrentInstalledComponent, currentTR);
                TargetRef cgPreviousTR = this.cgTargetRef(inPreviousInstalledComponent, previousTR);
                if (!cgCurrentTR.isVirtual()) {
                    Host oldHost = SingleHostQuery.byName(cgPreviousTR.getHostName()).select();
                    RoxAddress oldAddress = oldHost.getAppRA().getRoxAddress();
                    RoxAddress newAddress = new RoxAddress(cgCurrentTR.getIPAddr(), Integer.parseInt(cgCurrentTR.getPort()));
                    if (!oldAddress.ipString().equals(newAddress.ipString())) {
                        throw InstallDBException.targetableTRAddressChanged();
                    }
                }
            }
        }
        catch (PersistenceManagerException e) {
            throw new InstallDBException(e);
        }
        catch (RPCException e) {
            throw new InstallDBException(e);
        }
        catch (ConfigGenException e) {
            throw new InstallDBException(e);
        }
        catch (TransportException e) {
            throw new InstallDBException(e);
        }
    }

    protected TargetRef cgTargetRef(InstalledComponent inIC, TargetRef inTR) throws ConfigGenException, RPCException, InstallDBException {
        try {
            ConfigGenSubsystem cgsys = HostDBSubsystem.getInstance().getApplication().getConfigGenSubsystem();
            ComponentConfigManager cg = cgsys.getConfigGenerator().newComponentManager(inIC.getVariableSettingsID());
            return inTR.generate(cg);
        }
        catch (HostDBException e) {
            throw new InstallDBException(e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new InstallDBException(e);
        }
        catch (ComponentDBException e) {
            throw new InstallDBException(e);
        }
    }
}

