/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import [Lcom.raplix.rolloutexpress.systemmodel.installdb.Dependency;;
import [Lcom.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyCheckInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyViolationException;
import com.raplix.rolloutexpress.systemmodel.installdb.InMemoryHostContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContextBase;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.util.collections.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class InMemoryInstallDBContext
extends InstallDBContextBase
implements InstallDBContext {
    PersistentInstallDBContext mPersistentContext = new PersistentInstallDBContext();
    private HashMap mCreatedByID = new HashMap();
    private HashMap mDependentOnByID = new HashMap();
    private HashMap mInMemoryHostContextTable = new HashMap();
    private HashMap mCreatedComponentsByID = new HashMap();
    private HashMap mInstalledComponentsByID = new HashMap();
    private HashMap mInstalledComponentsByParentID = new HashMap();
    private HashMap mUninstalledComponentsByID = new HashMap();

    public synchronized InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        return this.createInstalledComponent(componentID, installPath, null, null, targetID, varSettingsID, taskID, planID, installBlockName, ctx, caller);
    }

    public synchronized InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, InstalledComponent parentContainer, String parentContainerRefName, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        InstalledComponent newInstalledComponent = this.newInstalledComponent(componentID, installPath, parentContainer, parentContainerRefName, targetID, varSettingsID, taskID, planID, installBlockName);
        InstalledComponent previousInstalledComp = this.isUpgrade(newInstalledComponent, ctx, caller);
        if (previousInstalledComp != null) {
            this.canUpgrade(newInstalledComponent, previousInstalledComp, ctx, caller);
        }
        newInstalledComponent.getData().setObjectID(InstalledComponentID.generateInstalledComponentID());
        this.mCreatedComponentsByID.put(newInstalledComponent.getID(), newInstalledComponent);
        Component theComponent = componentID.getByIDQuery().select();
        TargetRef tr = theComponent.getTargetRef();
        if (null != tr) {
            try {
                TargetRef trcg = this.cgTargetRef(newInstalledComponent, tr);
                Host.validateTargetableComponentHost(trcg);
            }
            catch (ConfigGenException e) {
                throw new InstallDBException(e);
            }
        }
        return newInstalledComponent;
    }

    public synchronized void installComponent(InstalledComponent installedComp, TargetedConfigContext ctx, Caller caller, NotificationManager notificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        InstalledComponent previousInstalledComp = this.isUpgrade(installedComp, ctx, caller);
        this.markComponentInstalled(installedComp);
        installedComp.getData().setInstallDate(new Date());
        if (previousInstalledComp != null) {
            this.markComponentUninstalled(previousInstalledComp, null);
            this.upgradeComponentDependencies(installedComp, previousInstalledComp, ctx);
        }
    }

    private void removeAllDependencies(InstalledComponentID inCompID) {
        this.setCreatedByList(inCompID, new Vector());
        Iterator it = this.mDependentOnByID.keySet().iterator();
        while (it.hasNext()) {
            InstalledComponentID icID = (InstalledComponentID)it.next();
            Vector depList = (Vector)this.mDependentOnByID.get(icID);
            Vector<Dependency> newDepList = new Vector<Dependency>();
            Iterator depIT = depList.iterator();
            while (depIT.hasNext()) {
                Dependency currDep = (Dependency)depIT.next();
                if (currDep.getDependantInstalledComponentID().equals(inCompID)) continue;
                newDepList.add(currDep);
            }
            this.mDependentOnByID.put(icID, newDepList);
        }
    }

    private void removeDependencies(InstalledComponentID fromCompID, InstalledComponentID toCompID) {
        Dependency currDep;
        if (fromCompID == null || toCompID == null) {
            return;
        }
        Vector depList = this.getCreatedByList(fromCompID);
        Iterator depIT = depList.iterator();
        while (depIT.hasNext()) {
            currDep = (Dependency)depIT.next();
            if (!currDep.getDependeeInstalledComponentID().equals(toCompID)) continue;
            depIT.remove();
        }
        this.setCreatedByList(fromCompID, depList);
        depList = this.getDependantOnList(toCompID);
        depIT = depList.iterator();
        while (depIT.hasNext()) {
            currDep = (Dependency)depIT.next();
            if (!currDep.getDependantInstalledComponentID().equals(fromCompID)) continue;
            depIT.remove();
        }
        this.setDependantOnList(toCompID, depList);
    }

    public synchronized void uninstallComponent(InstalledComponent inComp, TargetedConfigContext ctx, Caller caller, NotificationManager inNotificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        this.markComponentUninstalled(inComp, this.getUninstallerID(caller));
    }

    public void installComponentFailed(InstalledComponent inComp) throws InstallDBException, RPCException, PersistenceManagerException {
        this.removeInstalledByParent(inComp.getID());
    }

    public synchronized Dependency createDependency(String inName, Caller caller, InstalledComponentTargeter inDependencyTargeter, TargetedConfigContext ctx) throws InstallDBException, PersistenceManagerException, RPCException {
        this.validateDependencyTarget(caller, inDependencyTargeter, ctx);
        Dependency dep = new Dependency(inName, caller, inDependencyTargeter, ctx, this);
        Vector depList = this.getCreatedByList(dep.getDependantInstalledComponentID());
        depList.add(dep);
        this.setCreatedByList(dep.getDependantInstalledComponentID(), depList);
        depList = this.getDependantOnList(dep.getDependeeInstalledComponentID());
        depList.add(dep);
        this.setDependantOnList(dep.getDependeeInstalledComponentID(), depList);
        return dep;
    }

    synchronized void canUpgrade(InstalledComponent newCompVersion, InstalledComponent previousCompVersion, TargetedConfigContext ctx, Caller caller) throws InstallDBException, PersistenceManagerException, RPCException {
        this.validateReinstall(newCompVersion.getComponentID().getByIDQuery().select(), newCompVersion, previousCompVersion);
        DependencyCheckInstallDBContext theContext = new DependencyCheckInstallDBContext(newCompVersion.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID(), newCompVersion, this);
        Vector depList = this.getDependantOnList(previousCompVersion.getID());
        try {
            for (int i = 0; i < depList.size(); ++i) {
                Dependency currDep = (Dependency)depList.get(i);
                currDep.checkDependency(ctx.getTargetHost(), newCompVersion, theContext);
            }
        }
        catch (DependencyViolationException e) {
            throw DependencyViolationException.cannotUpgradeComponentDoesNotSatisfyDependants(newCompVersion, previousCompVersion);
        }
        this.mPersistentContext.canUpgrade(newCompVersion, previousCompVersion, ctx, caller);
    }

    public synchronized InstalledComponent getInstalledComponent(HostID hostID, InstalledComponentRef compRef, TargetType lookupType) throws PersistenceManagerException, RPCException {
        InstalledComponent result = null;
        InMemoryHostContext hostContext = this.getInMemoryHostContext(hostID);
        InMemoryHostContext.InstalledComponentMatch match = null;
        match = hostContext.getLatestInstalledComponent(compRef);
        result = match.getMatchType().equals(InMemoryHostContext.InstalledComponentMatchType.NOT_INSTALLED) ? this.mPersistentContext.getInstalledComponent(hostID, compRef, lookupType) : match.getInstalledComponent();
        return result;
    }

    public InstalledComponent getInstalledComponent(HostID hostID, String typeName, String installPath) throws PersistenceManagerException, RPCException {
        InMemoryHostContext hostCtx = this.getInMemoryHostContext(hostID);
        InstalledComponent theMatch = hostCtx.getLatestInstalledComponent(typeName, installPath);
        if (theMatch != null) {
            return theMatch;
        }
        MultiInstalledComponentQuery icQ = MultiInstalledComponentQuery.byType(hostID, TargetType.CURRENT, typeName, installPath);
        InstalledComponent[] results = icQ.selectICView();
        for (int i = 0; i < results.length; ++i) {
            InstalledComponent currIC = results[i];
            SummaryComponent currComp = currIC.getComponentID().getByIDQuery().selectSummaryView();
            InstalledComponentRef icRef = new InstalledComponentRef(currComp.getPath(), currComp.getName(), null, null, false, currIC.getInstallPath(), true);
            InMemoryHostContext.InstalledComponentMatch match = hostCtx.getLatestInstalledComponent(icRef);
            if (!match.getMatchType().equals(InMemoryHostContext.InstalledComponentMatchType.NOT_INSTALLED)) continue;
            return currIC;
        }
        return null;
    }

    public synchronized InstalledComponent getNestedComponent(InstalledComponentID parentID, String compRefName) throws PersistenceManagerException, RPCException {
        Vector children = (Vector)this.mInstalledComponentsByParentID.get(parentID);
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                InstalledComponent currChild = (InstalledComponent)it.next();
                if (!currChild.getParentContainerRefName().equals(compRefName)) continue;
                return currChild;
            }
            return null;
        }
        return this.mPersistentContext.getNestedComponent(parentID, compRefName);
    }

    public synchronized InstalledComponent[] getNestedComponents(InstalledComponentID parentID) throws PersistenceManagerException, RPCException {
        Vector children = (Vector)this.mInstalledComponentsByParentID.get(parentID);
        if (children != null) {
            InstalledComponent[] nestedComps = (InstalledComponent[])CollectionUtil.mapClass(children.toArray(), InstalledComponent;.class);
            return nestedComps;
        }
        return this.mPersistentContext.getNestedComponents(parentID);
    }

    private synchronized void upgradeComponentDependencies(InstalledComponent newCompVersion, InstalledComponent previousCompVersion, TargetedConfigContext ctx) throws InstallDBException, PersistenceManagerException, RPCException {
        Vector depList = this.getDependantOnList(previousCompVersion.getID());
        Dependency[] persistentDeps = this.mPersistentContext.queryDependantsOf(previousCompVersion.getID(), null);
        depList.addAll(Arrays.asList(persistentDeps));
        Vector<Dependency> newDepList = new Vector<Dependency>();
        for (int i = 0; i < depList.size(); ++i) {
            Dependency currDep = (Dependency)depList.get(i);
            InstalledComponent dependantInstalledComp = this.getInstalledComponent(currDep.getDependantInstalledComponentID());
            Component dependantComp = dependantInstalledComp.getComponentID().getByIDQuery().select();
            Component dependantDeclaredComp = dependantComp.getAncestorByExtendsTypeName(currDep.getDependantDeclaredComponentExtendsTypeName());
            Dependency newDep = new Dependency(currDep.getName(), new Caller(dependantInstalledComp, dependantComp, dependantDeclaredComp), currDep.getInstalledComponentTargeter(), ctx, this);
            newDepList.add(newDep);
            Vector createdByList = this.getCreatedByList(currDep.getDependantInstalledComponentID());
            createdByList.remove(currDep);
            createdByList.add(newDep);
            this.setCreatedByList(currDep.getDependantInstalledComponentID(), createdByList);
        }
        this.setDependantOnList(newCompVersion.getID(), newDepList);
        this.removeAllDependencies(previousCompVersion.getID());
    }

    public synchronized Dependency[] queryDependenciesCreatedBy(InstalledComponentID creatingInstalledComponentID, String depName) throws RPCException, PersistenceManagerException {
        Vector depList = this.getCreatedByList(creatingInstalledComponentID);
        if (depList.size() > 0) {
            depList = this.pruneListByName(this.getCreatedByList(creatingInstalledComponentID), depName);
            Collections.sort(depList, new DependencyComparator());
            Dependency[] depArray = (Dependency[])CollectionUtil.mapClass(depList.toArray(), Dependency;.class);
            return depArray;
        }
        if (this.getInstalledComponentsByID(creatingInstalledComponentID) == null && this.mUninstalledComponentsByID.get(creatingInstalledComponentID) == null) {
            Dependency[] depArray = this.mPersistentContext.queryDependenciesCreatedBy(creatingInstalledComponentID, depName);
            for (int i = 0; i < depArray.length; ++i) {
                InstalledComponentID dependee = depArray[i].getDependeeInstalledComponentID();
                if (this.mUninstalledComponentsByID.containsKey(dependee)) continue;
                depList.add(depArray[i]);
            }
            if (depList.size() > 0) {
                return depList.toArray(new Dependency[0]);
            }
        }
        return new Dependency[0];
    }

    public synchronized Dependency[] queryDependantsOf(InstalledComponentID installedComponentID, String depName) throws RPCException, PersistenceManagerException {
        if (this.mUninstalledComponentsByID.containsKey(installedComponentID)) {
            return new Dependency[0];
        }
        Vector depList = this.getDependantOnList(installedComponentID);
        depList = this.pruneListByName(depList, depName);
        Dependency[] persistDeps = this.mPersistentContext.queryDependantsOf(installedComponentID, depName);
        for (int i = 0; i < persistDeps.length; ++i) {
            Dependency currDep = persistDeps[i];
            if (this.mUninstalledComponentsByID.get(currDep.getDependantInstalledComponentID()) != null) continue;
            depList.add(currDep);
        }
        Collections.sort(depList, new DependencyComparator());
        Dependency[] depArray = (Dependency[])CollectionUtil.mapClass(depList.toArray(), Dependency;.class);
        return depArray;
    }

    private Vector pruneListByName(Vector inList, String depName) {
        Vector<Dependency> newList = new Vector<Dependency>();
        Iterator it = inList.iterator();
        while (it.hasNext()) {
            Dependency currDep = (Dependency)it.next();
            if (depName != null && !currDep.getName().equals(depName)) continue;
            newList.add(currDep);
        }
        return newList;
    }

    private synchronized InstalledComponent getInstalledComponentsByID(InstalledComponentID inID) {
        return (InstalledComponent)this.mInstalledComponentsByID.get(inID);
    }

    private synchronized Vector getDependantOnList(InstalledComponentID icID) {
        Vector results = (Vector)this.mDependentOnByID.get(icID);
        if (results == null) {
            results = new Vector();
        }
        return results;
    }

    private synchronized void setDependantOnList(InstalledComponentID icID, Vector inList) {
        this.mDependentOnByID.put(icID, inList);
    }

    private synchronized Vector getCreatedByList(InstalledComponentID icID) {
        Vector results = (Vector)this.mCreatedByID.get(icID);
        if (results == null) {
            results = new Vector();
        }
        return results;
    }

    private synchronized void setCreatedByList(InstalledComponentID icID, Vector inList) {
        this.mCreatedByID.put(icID, inList);
    }

    private synchronized void markComponentInstalled(InstalledComponent installedComp) throws RPCException, PersistenceManagerException {
        HostID currHostID = installedComp.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID();
        InMemoryHostContext ctx = this.getInMemoryHostContext(currHostID);
        ctx.markComponentInstalled(installedComp);
        if (installedComp.getParentContainerID() == null) {
            this.mInstalledComponentsByID.put(installedComp.getID(), installedComp);
        } else {
            this.addInstalledByParent(installedComp.getParentContainerID(), installedComp);
        }
    }

    private synchronized void markComponentUninstalled(InstalledComponent installedComp, InstalledComponentID uninstaller) throws RPCException, PersistenceManagerException {
        HostID currHostID = installedComp.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID();
        InMemoryHostContext hostCtx = this.getInMemoryHostContext(currHostID);
        hostCtx.markComponentUninstalled(installedComp);
        this.mInstalledComponentsByID.remove(installedComp.getID());
        this.removeInstalledByParent(installedComp.getID());
        this.removeDependencies(uninstaller, installedComp.getID());
        this.mUninstalledComponentsByID.put(installedComp.getID(), installedComp);
    }

    private synchronized Vector getInstalledComponentsByParentID(InstalledComponentID parentID) {
        Vector results = (Vector)this.mInstalledComponentsByParentID.get(parentID);
        if (results == null) {
            results = new Vector();
        }
        return results;
    }

    private synchronized void addInstalledByParent(InstalledComponentID parentID, InstalledComponent child) {
        Vector theChildren = this.getInstalledComponentsByParentID(parentID);
        theChildren.add(child);
        this.mInstalledComponentsByParentID.put(parentID, theChildren);
    }

    private synchronized void removeInstalledByParent(InstalledComponentID parentID) {
        Vector theChildren = this.getInstalledComponentsByParentID(parentID);
        Iterator it = theChildren.iterator();
        while (it.hasNext()) {
            InstalledComponent currChild = (InstalledComponent)it.next();
            this.removeInstalledByParent(currChild.getID());
        }
        this.removeAllDependencies(parentID);
        this.mInstalledComponentsByParentID.remove(parentID);
    }

    private synchronized InMemoryHostContext getInMemoryHostContext(HostID hostID) {
        InMemoryHostContext ctx = (InMemoryHostContext)this.mInMemoryHostContextTable.get(hostID);
        if (ctx == null) {
            ctx = new InMemoryHostContext(hostID);
            this.setInMemoryHostContext(hostID, ctx);
        }
        return ctx;
    }

    public synchronized void setInMemoryHostContext(HostID hostID, InMemoryHostContext ctx) {
        this.mInMemoryHostContextTable.put(hostID, ctx);
    }

    public InstalledComponent getInstalledComponent(InstalledComponentID inID) throws RPCException, PersistenceManagerException {
        InstalledComponent ic = (InstalledComponent)this.mCreatedComponentsByID.get(inID);
        if (ic == null) {
            ic = this.mPersistentContext.getInstalledComponent(inID);
        }
        return ic;
    }

    protected boolean searchForInstalledComps(SummaryHost inHost) throws RPCException, PersistenceManagerException {
        InMemoryHostContext ctx = this.getInMemoryHostContext(inHost.getID());
        if (ctx.hasInstalledComponents()) {
            return true;
        }
        InstalledComponent[] instComps = MultiInstalledComponentQuery.byHost(inHost.getID(), TargetType.CURRENT).selectICView();
        for (int i = 0; i < instComps.length; ++i) {
            if (ctx.isComponentUninstalled(instComps[i])) continue;
            return true;
        }
        return false;
    }

    private class DependencyComparator
    implements Comparator {
        private DependencyComparator() {
        }

        public int compare(Object o1, Object o2) {
            Dependency dep1 = (Dependency)o1;
            Dependency dep2 = (Dependency)o2;
            return dep1.getName().compareTo(dep2.getName());
        }

        public boolean equals(Object o) {
            return o instanceof DependencyComparator;
        }
    }
}

