/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContextBase;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.util.logger.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class InMemoryHostContext {
    private HostID mHostID;
    private HashMap mInstalledComponentsByID = new HashMap();
    private HashMap mUninstalledComponentsByID = new HashMap();

    public InMemoryHostContext(HostID inHostID) {
        this.mHostID = inHostID;
    }

    public void markComponentInstalled(InstalledComponent inInstalledComp) throws RPCException, PersistenceManagerException {
        if (inInstalledComp.getParentContainerID() != null) {
            return;
        }
        Component newComp = inInstalledComp.getComponentID().getByIDQuery().select();
        this.removeMatchingComp(this.mInstalledComponentsByID, inInstalledComp);
        this.removeMatchingComp(this.mUninstalledComponentsByID, inInstalledComp);
        this.mInstalledComponentsByID.put(inInstalledComp.getID(), new InstalledData(inInstalledComp, newComp, System.currentTimeMillis()));
    }

    private InstalledComponent removeMatchingComp(HashMap inCompMap, InstalledComponent inInstalledComp) throws RPCException, PersistenceManagerException {
        Iterator it = inCompMap.values().iterator();
        while (it.hasNext()) {
            InstalledData currInstallData = (InstalledData)it.next();
            InstalledComponentRef compRef = new InstalledComponentRef(currInstallData.getComponentPath(), currInstallData.getComponentName(), null, Comparator.EQUAL, false, currInstallData.getInstallPath(), true);
            InstalledComponentMatchType matchType = InMemoryHostContext.matchesInstalledComponent(compRef, inInstalledComp);
            if (matchType.equals(InstalledComponentMatchType.NOT_INSTALLED)) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("removing " + currInstallData + " and replacing with: " + inInstalledComp, this);
            }
            it.remove();
            return currInstallData.getInstalledComponent();
        }
        return null;
    }

    public void markComponentUninstalled(InstalledComponent inInstalledComp) throws RPCException, PersistenceManagerException {
        if (inInstalledComp.getParentContainerID() != null) {
            return;
        }
        this.mInstalledComponentsByID.remove(inInstalledComp.getID());
        Component newComp = inInstalledComp.getComponentID().getByIDQuery().select();
        this.mUninstalledComponentsByID.put(inInstalledComp.getID(), new InstalledData(inInstalledComp, newComp, System.currentTimeMillis()));
    }

    public InstalledComponentMatch getLatestInstalledComponent(InstalledComponentRef inCompRef) throws PersistenceManagerException, RPCException {
        InstalledComponentMatchType currMatchType;
        InstalledData currPair;
        Iterator it = this.mInstalledComponentsByID.values().iterator();
        Vector<InstalledData> matchingInstalledCompsVector = new Vector<InstalledData>();
        InstalledComponentMatch diffVersionMatch = null;
        while (it.hasNext()) {
            currPair = (InstalledData)it.next();
            currMatchType = InMemoryHostContext.matchesInstalledComponent(inCompRef, currPair.getInstalledComponent());
            if (currMatchType.equals(InstalledComponentMatchType.DIFF_VERSION_INSTALLED)) {
                diffVersionMatch = new InstalledComponentMatch(InstalledComponentMatchType.DIFF_VERSION_INSTALLED, null);
            }
            if (!currMatchType.equals(InstalledComponentMatchType.INSTALLED)) continue;
            matchingInstalledCompsVector.add(currPair);
        }
        if (matchingInstalledCompsVector.size() > 0) {
            InstalledData[] allResults = matchingInstalledCompsVector.toArray(new InstalledData[0]);
            Arrays.sort(allResults, new InstalledData());
            return new InstalledComponentMatch(InstalledComponentMatchType.INSTALLED, allResults[0].mInstalledComp);
        }
        if (diffVersionMatch != null) {
            return diffVersionMatch;
        }
        it = this.mUninstalledComponentsByID.values().iterator();
        while (it.hasNext()) {
            currPair = (InstalledData)it.next();
            currMatchType = InMemoryHostContext.matchesInstalledComponent(inCompRef, currPair.getInstalledComponent());
            if (currMatchType.equals(InstalledComponentMatchType.DIFF_VERSION_INSTALLED)) {
                return new InstalledComponentMatch(InstalledComponentMatchType.UNINSTALLED, null);
            }
            if (!currMatchType.equals(InstalledComponentMatchType.INSTALLED)) continue;
            return new InstalledComponentMatch(InstalledComponentMatchType.UNINSTALLED, null);
        }
        return new InstalledComponentMatch(InstalledComponentMatchType.NOT_INSTALLED, null);
    }

    public InstalledComponent getLatestInstalledComponent(String typeName, String installPath) throws PersistenceManagerException, RPCException {
        Iterator it = this.mInstalledComponentsByID.values().iterator();
        String localInstallPath = installPath != null ? InstalledComponentRef.toUniversalPath(installPath) : null;
        InstalledComponent match = null;
        Vector<InstalledData> matchingInstalledCompsVector = new Vector<InstalledData>();
        while (it.hasNext()) {
            Component currComp;
            InstalledData currPair = (InstalledData)it.next();
            String currInstallPath = currPair.getInstallPath();
            if (localInstallPath != null && !localInstallPath.equals(currInstallPath) || (currComp = currPair.mComp).getAncestorByExtendsTypeName(typeName) == null) continue;
            matchingInstalledCompsVector.add(currPair);
        }
        if (matchingInstalledCompsVector.size() > 0) {
            InstalledData[] allResults = matchingInstalledCompsVector.toArray(new InstalledData[0]);
            Arrays.sort(allResults, new InstalledData());
            match = allResults[0].mInstalledComp;
        }
        return match;
    }

    public static InstalledComponentMatchType matchesInstalledComponent(InstalledComponentRef compRef, InstalledComponent iComp) throws PersistenceManagerException, RPCException {
        InstalledComponentMatchType matchType = InstalledComponentMatchType.NOT_INSTALLED;
        if (iComp.getParentContainerID() != null) {
            return matchType;
        }
        compRef = compRef.toUniversal();
        SummaryComponent theComp = iComp.getComponentID().getByIDQuery().selectSummaryView();
        if (theComp.getPath().equals(compRef.getPath()) && theComp.getName().equals(compRef.getComponentName()) && (compRef.getInstallPath() == null || iComp.getInstallPath().equals(compRef.getInstallPath()))) {
            if (compRef.getComponentVersion() == null) {
                matchType = InstalledComponentMatchType.INSTALLED;
            } else {
                Comparator comp = compRef.getVersionComparator();
                VersionNumber myCompVersion = theComp.getVersionNumber();
                VersionNumber compRefVersion = new VersionNumber(compRef.getComponentVersion());
                boolean matches = false;
                if (Comparator.EQUAL.equals(comp)) {
                    matches = myCompVersion.equals(compRefVersion);
                } else if (Comparator.GREATER_THAN.equals(comp)) {
                    matches = myCompVersion.isGreaterThan(compRefVersion);
                } else {
                    boolean bl = matches = myCompVersion.equals(compRefVersion) || myCompVersion.isGreaterThan(compRefVersion);
                }
                if (matches && InstallDBContextBase.shouldCheckCallCompatibility(compRef)) {
                    matches = InMemoryHostContext.isCallCompatibleWith(theComp, compRef);
                }
                if (matches) {
                    matchType = InstalledComponentMatchType.INSTALLED;
                } else if (compRef.getInstallPath() != null) {
                    matchType = InstalledComponentMatchType.DIFF_VERSION_INSTALLED;
                }
            }
        }
        return matchType;
    }

    private static boolean isCallCompatibleWith(SummaryComponent comp, InstalledComponentRef compRef) throws PersistenceManagerException, RPCException {
        ComponentID otherCompID;
        try {
            otherCompID = SingleComponentQuery.byRef(compRef).selectSummaryView().getID();
        }
        catch (NoResultsFoundException e) {
            return false;
        }
        return comp.getID().isCallCompatibleWith(otherCompID);
    }

    public boolean isComponentUninstalled(InstalledComponent iComp) {
        return this.mUninstalledComponentsByID.containsKey(iComp.getID());
    }

    public boolean hasInstalledComponents() {
        return this.mInstalledComponentsByID.size() != 0;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(this.mHostID.toString());
        buf.append("]");
        return buf.toString();
    }

    private class InstalledData
    implements java.util.Comparator {
        private InstalledComponent mInstalledComp;
        private Component mComp;
        private long mTimestamp;

        private InstalledData() {
        }

        private InstalledData(InstalledComponent inInstalledComp, Component inComp, long inTimestamp) {
            this.mInstalledComp = inInstalledComp;
            this.mComp = inComp;
            this.mTimestamp = inTimestamp;
        }

        String getInstallPath() {
            return this.mInstalledComp.getInstallPath();
        }

        String getComponentName() {
            return this.mComp.getName();
        }

        FolderID getComponentPath() {
            return this.mComp.getPath();
        }

        String getExtendsTypeName() {
            return this.mComp.getExtendsTypeName();
        }

        InstalledComponent getInstalledComponent() {
            return this.mInstalledComp;
        }

        public int compare(Object o1, Object o2) {
            InstalledData data1 = (InstalledData)o1;
            InstalledData data2 = (InstalledData)o2;
            return (int)(data2.mTimestamp - data1.mTimestamp);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof InstalledData)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            InstalledData data = (InstalledData)o;
            return this.mTimestamp == data.mTimestamp && this.mInstalledComp.equals(data.mInstalledComp) && this.mComp.equals(data.mComp);
        }
    }

    public static class InstalledComponentMatchType {
        int mMatchType;
        public static final InstalledComponentMatchType INSTALLED = new InstalledComponentMatchType(0);
        public static final InstalledComponentMatchType NOT_INSTALLED = new InstalledComponentMatchType(1);
        public static final InstalledComponentMatchType DIFF_VERSION_INSTALLED = new InstalledComponentMatchType(2);
        public static final InstalledComponentMatchType UNINSTALLED = new InstalledComponentMatchType(3);

        InstalledComponentMatchType(int matchType) {
            this.mMatchType = matchType;
        }
    }

    public static class InstalledComponentMatch {
        InstalledComponentMatchType mMatchType;
        InstalledComponent mInstalledComponent;

        public InstalledComponentMatch(InstalledComponent ic) {
            this.mInstalledComponent = ic;
            this.mMatchType = ic == null ? InstalledComponentMatchType.NOT_INSTALLED : InstalledComponentMatchType.INSTALLED;
        }

        public InstalledComponentMatch(InstalledComponentMatchType matchType, InstalledComponent ic) {
            this.mMatchType = matchType;
            this.mInstalledComponent = ic;
        }

        public InstalledComponentMatchType getMatchType() {
            return this.mMatchType;
        }

        public InstalledComponent getInstalledComponent() {
            return this.mInstalledComponent;
        }
    }
}

