/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.Messages;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;

public class DependencyViolationException
extends InstallDBException
implements Messages {
    private DependencyViolationException() {
    }

    public DependencyViolationException(ROXMessage msg, Throwable t) {
        super(msg, t);
    }

    public DependencyViolationException(ROXMessage msg) {
        super(msg);
    }

    public DependencyViolationException(Throwable t) {
        super(t);
    }

    static DependencyViolationException cannotUpgradeComponentDoesNotSatisfyDependants(InstalledComponent newComp, InstalledComponent oldComp) throws RPCException, PersistenceManagerException {
        String newCompName = newComp.getComponentID().getByIDQuery().selectSummaryView().getName();
        return new DependencyViolationException(new ROXMessage("installdb.CANNOT_UPGRADE_COMPONENT_DOES_NOT_SATISFY_DEPENDANTS", new String[]{newCompName}));
    }

    static DependencyViolationException cannotUninstallComponentWithDependants(InstalledComponent installedComp) throws RPCException, PersistenceManagerException {
        String uninstallCompName = installedComp.getComponentID().getByIDQuery().selectSummaryView().getName();
        return new DependencyViolationException(new ROXMessage("installdb.CANNOT_UNINSTALL_COMPONENT_WITH_DEPENDANTS", new String[]{uninstallCompName}));
    }

    static DependencyViolationException cannotCreateDependencyOnCompBeingUpgraded(String target) throws RPCException, PersistenceManagerException {
        return new DependencyViolationException(new ROXMessage("installdb.CANNOT_CREATE_DEPENDENCY_ON_COMP_BEING_UPGRADED", new String[]{target}));
    }

    static DependencyViolationException unableToResolveDependencyTarget(InstalledComponentTargeter targeter, RaplixException e) {
        return new DependencyViolationException(new ROXMessage("installdb.UNABLE_TO_RESOLVE_DEPENDENCY_TARGET", new String[]{((Object)targeter).toString()}), (Throwable)e);
    }

    static DependencyViolationException resolvedDependencyDoesNotMatchExpectedValue(InstalledComponentID expected, InstalledComponentID actual) {
        return new DependencyViolationException(new ROXMessage("installdb.UNABLE_TO_RESOLVE_DEPENDENCY_TARGET", new Object[]{expected}));
    }
}

