/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;

class DependencySQLOps
extends DependencyImplTable {
    public static final DependencySQLOps DEFAULT = new DependencySQLOps();

    public DependencySQLOps(String alias) {
        super(alias);
    }

    private DependencySQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new DependencySQLOps(alias);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return DependencySQLOps.dictOrderAsc(this.Name);
    }

    public ConditionalExpression equalsName(String name) {
        return DependencySQLOps.equals(this.Name, name);
    }

    public ConditionalExpression isDependantInstallComponentID(InstalledComponentID ID2) {
        return DependencySQLOps.equals(this.DependantInstalledComponentID, ID2);
    }

    public ConditionalExpression isDependantInstallComponentIDs(InstalledComponentID[] IDs) {
        return DependencySQLOps.emptyIn(this.DependantInstalledComponentID, DependencySQLOps.rList(IDs));
    }

    public ConditionalExpression isDependeeInstallComponentID(InstalledComponentID ID2) {
        return DependencySQLOps.equals(this.DependeeInstalledComponentID, ID2);
    }

    public ConditionalExpression isDependeeInstallComponentIDs(InstalledComponentID[] IDs) {
        return DependencySQLOps.emptyIn(this.DependeeInstalledComponentID, DependencySQLOps.rList(IDs));
    }

    public void upgradeDependencies(InstalledComponentID previousInstalledCompID, InstalledComponentID newInstalledCompID) throws PersistenceManagerException {
        ConditionalExpression cond = this.isDependeeInstallComponentID(previousInstalledCompID);
        SetList setList = DependencySQLOps.uList();
        setList.add(DependencySQLOps.set(this.DependeeInstalledComponentID, newInstalledCompID));
        setList.add(DependencySQLOps.increment(this.UpdateCount));
        DependencySQLOps.execute(this.update(setList, DependencySQLOps.where(cond)));
    }

    public void removeDependencies(InstalledComponentID dependantCompID) throws PersistenceManagerException {
        ConditionalExpression cond = this.isDependantInstallComponentID(dependantCompID);
        DependencySQLOps.execute(this.delete(DependencySQLOps.where(cond)));
    }
}

