/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiCompObserverQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImpl;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyToComponentNameRefTable;
import java.util.ArrayList;

class DependencyObserverQuery
implements MultiCompObserverQuery {
    private static DependencyObserverQuery sInstance = null;

    private DependencyObserverQuery() {
    }

    public static DependencyObserverQuery getInstance() {
        if (sInstance == null) {
            sInstance = new DependencyObserverQuery();
        }
        return sInstance;
    }

    public ComponentObserver[] selectCompObservers(String name, SummaryFolder path) throws PersistenceManagerException {
        try {
            String pathStr = path.getFullPathString();
            NameRef[] nrs = DependencyToComponentNameRefTable.DEFAULT.getByChildNameAndPath(name, pathStr);
            DependencyIDSet id = new DependencyIDSet();
            NameRef.parentIDSet(nrs, id);
            Dependency[] deps = id.getByIDsQuery().select();
            ArrayList<DependencyImpl> al = new ArrayList<DependencyImpl>();
            for (int i = 0; i < deps.length; ++i) {
                al.add(deps[i].getImpl());
            }
            return al.toArray(new DependencyImpl[0]);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public void updateCompRefTable(String oldName, FolderID oldPath, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        DependencyToComponentNameRefTable.DEFAULT.updateNameRefs(oldName, oldPath, newName, newPath);
    }
}

