/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyID;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;

class DependencyImpl
extends PersistentBean
implements Cloneable,
ComponentObserver {
    private InstalledComponentID mDependantInstalledComponentID;
    private String mDependantDeclaredComponentExtendsTypeName;
    private InstalledComponentID mDependeeInstalledComponentID;
    private String mDependeeDeclaredComponentExtendsTypeName;
    private InstalledComponentTargeter mInstalledComponentTargeter;
    private String mName;

    private DependencyImpl() {
    }

    static DependencyImpl create() {
        DependencyImpl result = new DependencyImpl();
        return result;
    }

    DependencyID getID() {
        return (DependencyID)super.getObjectID();
    }

    String getDependantDeclaredComponentExtendsTypeName() {
        return this.mDependantDeclaredComponentExtendsTypeName;
    }

    void setDependantDeclaredComponentExtendsTypeName(String dependantDeclaredComponentExtendsTypeName) {
        this.mDependantDeclaredComponentExtendsTypeName = dependantDeclaredComponentExtendsTypeName;
    }

    InstalledComponentID getDependeeInstalledComponentID() {
        return this.mDependeeInstalledComponentID;
    }

    void setDependeeInstalledComponentID(InstalledComponentID dependeeInstalledComponentID) {
        if (dependeeInstalledComponentID == null) {
            throw new NullPointerException();
        }
        this.mDependeeInstalledComponentID = dependeeInstalledComponentID;
    }

    String getDependeeDeclaredComponentExtendsTypeName() {
        return this.mDependeeDeclaredComponentExtendsTypeName;
    }

    void setDependeeDeclaredComponentExtendsTypeName(String dependeeDeclaredComponentExtendsTypeName) {
        this.mDependeeDeclaredComponentExtendsTypeName = dependeeDeclaredComponentExtendsTypeName;
    }

    private String getInstalledComponentTargeterAsString() {
        return this.mInstalledComponentTargeter.writeToString();
    }

    private void setInstalledComponentTargeterAsString(String inTargeterString) throws SystemModelParseException {
        this.mInstalledComponentTargeter = ComponentTargeterFactory.getInstalledTargeter(inTargeterString);
    }

    InstalledComponentTargeter getInstalledComponentTargeter() {
        return this.mInstalledComponentTargeter;
    }

    void setInstalledComponentTargeter(InstalledComponentTargeter installedComponentTargeter) {
        if (installedComponentTargeter == null) {
            throw new NullPointerException();
        }
        this.mInstalledComponentTargeter = installedComponentTargeter;
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    InstalledComponentID getDependantInstalledComponentID() {
        return this.mDependantInstalledComponentID;
    }

    void setDependantInstalledComponentID(InstalledComponentID dependantInstalledComponentID) {
        if (dependantInstalledComponentID == null) {
            throw new NullPointerException();
        }
        this.mDependantInstalledComponentID = dependantInstalledComponentID;
    }

    Dependency getCompleteViewMS() {
        return new Dependency(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save() throws PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(null);
    }

    protected void saveMS(final PersistContext context) throws PersistenceManagerException {
        DependencyImpl.transactMS(new AcquireReadLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                DependencyImpl.this.executeSaveMS(context);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("installdb.SAVING_DEPENDENCY", DependencyImpl.this.getName());
            }
        });
    }

    private void executeSaveMS(PersistContext context) throws PersistenceManagerException {
        super.saveMS(context);
        DependencyToComponentNameRefTable dept = DependencyToComponentNameRefTable.DEFAULT;
        dept.removeByParentID(this.getID());
        NameRefSet set = new NameRefSet();
        this.addComponentRefsMS(set);
        dept.addReferences(this.getID(), set);
    }

    private void saveOnlyMS() throws PersistenceManagerException {
        super.saveMS(null);
    }

    private void validate() {
    }

    void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        ComponentNameRefAdder adder = new ComponentNameRefAdder(set, this.getCallerMS());
        try {
            adder.visit(this.getInstalledComponentTargeter());
        }
        catch (Exception e) {
            throw adder.mapException(e);
        }
    }

    DependencyImpl updateComponentRefsMS(SummaryComponent sc, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ComponentNameRefUpdater updater = new ComponentNameRefUpdater(sc, this.getCallerMS(), newName, newPath);
        DependencyImpl result = (DependencyImpl)this.clone();
        try {
            result.setInstalledComponentTargeter(updater.transform(this.getInstalledComponentTargeter()));
            return result;
        }
        catch (Exception e) {
            throw updater.mapException(e);
        }
    }

    public void renameComponent(SummaryComponent sc, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
        this.updateComponentRefsMS(sc, name, path).saveOnlyMS();
    }

    private Caller getCallerMS() throws PersistenceManagerException {
        Caller real;
        try {
            InstalledComponent ic = this.getDependantInstalledComponentID().getByIDQuery().select();
            Component actual = ic.getComponentID().getByIDQuery().select();
            Component declared = actual.getAncestorByExtendsTypeName(this.getDependantDeclaredComponentExtendsTypeName());
            real = new Caller(ic, actual, declared);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return real;
    }
}

