/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InMemoryHostContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;

class DependencyCheckInstallDBContext
implements InstallDBContext {
    private InstalledComponent mInstalledComp;
    private InstallDBContext mSubContext;
    private HostID mHostID;

    DependencyCheckInstallDBContext(HostID inHostID, InstalledComponent installedComp, InstallDBContext subContext) throws RPCException, PersistenceManagerException {
        this.mInstalledComp = installedComp;
        this.mSubContext = subContext;
        this.mHostID = inHostID;
    }

    public InstalledComponent getInstalledComponent(HostID hostID, InstalledComponentRef compRef, TargetType lookupType) throws PersistenceManagerException, RPCException {
        if (this.mHostID.equals(hostID)) {
            InMemoryHostContext.InstalledComponentMatchType match = InMemoryHostContext.matchesInstalledComponent(compRef, this.mInstalledComp);
            if (match.equals(InMemoryHostContext.InstalledComponentMatchType.INSTALLED)) {
                return this.mInstalledComp;
            }
            if (match.equals(InMemoryHostContext.InstalledComponentMatchType.DIFF_VERSION_INSTALLED)) {
                return null;
            }
        }
        return this.mSubContext.getInstalledComponent(hostID, compRef);
    }

    public InstalledComponent getInstalledComponent(HostID hostID, InstalledComponentRef compRef) throws PersistenceManagerException, RPCException {
        return this.getInstalledComponent(hostID, compRef, TargetType.CURRENT);
    }

    public InstalledComponent getInstalledComponent(HostID hostID, String typeName, String installPath) throws PersistenceManagerException, RPCException {
        if (this.mInstalledComp.getParentContainerID() == null && this.mHostID.equals(hostID) && (installPath == null || installPath.equals(this.mInstalledComp.getInstallPath())) && this.mInstalledComp.getComponentID().getByIDQuery().select().getAncestorByExtendsTypeName(typeName) != null) {
            return this.mInstalledComp;
        }
        return this.mSubContext.getInstalledComponent(hostID, typeName, installPath);
    }

    public InstalledComponent getInstalledComponent(InstalledComponentID inID) throws RPCException, PersistenceManagerException {
        return this.mSubContext.getInstalledComponent(inID);
    }

    public InstalledComponent getNestedComponent(InstalledComponentID parentID, String compRefName) throws PersistenceManagerException, RPCException {
        return this.mSubContext.getNestedComponent(parentID, compRefName);
    }

    public InstalledComponent[] getNestedComponents(InstalledComponentID parentID) throws PersistenceManagerException, RPCException {
        return this.mSubContext.getNestedComponents(parentID);
    }

    public InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public InstalledComponent createInstalledComponent(ComponentID componentID, String installPath, InstalledComponent parentContainer, String parentContainerRefName, TargetID targetID, GeneratedVariableSettingsID varSettingsID, TaskID taskID, ExecutionPlanID planID, String installBlockName, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public void installComponent(InstalledComponent installedComp, TargetedConfigContext ctx, Caller caller, NotificationManager notificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public void installComponentFailed(InstalledComponent inComp) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public void canUninstallComponent(InstalledComponent inComp, TargetedConfigContext ctx, Caller caller) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public void uninstallComponent(InstalledComponent inComp, TargetedConfigContext ctx, Caller caller, NotificationManager inNotificationManager) throws InstallDBException, RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public Dependency createDependency(String inName, Caller caller, InstalledComponentTargeter inDependencyTargeter, TargetedConfigContext ctx) throws InstallDBException, PersistenceManagerException, RPCException {
        throw new UnsupportedOperationException();
    }

    public Dependency[] queryDependenciesCreatedBy(InstalledComponentID creatingInstalledComponentID, String depName) throws RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }

    public Dependency[] queryDependantsOf(InstalledComponentID installedComponentID, String depName) throws RPCException, PersistenceManagerException {
        throw new UnsupportedOperationException();
    }
}

