/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.installdb;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyCheckTargetedConfigContext;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyID;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImpl;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyViolationException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;

public class Dependency
implements RPCSerializable,
StandardObject,
UsingObject,
ComponentReferrer {
    private boolean mImplIsCopy = true;
    private DependencyImpl mImpl;

    Dependency(String inName, Caller caller, InstalledComponentTargeter inDependencyTargeter, TargetedConfigContext ctx, InstallDBContext installDBContext) throws InstallDBException {
        this();
        this.getMutableImpl().setName(inName);
        this.getMutableImpl().setDependantInstalledComponentID(caller.getInstalledComponent().getID());
        this.getMutableImpl().setDependantDeclaredComponentExtendsTypeName(caller.getDeclaredComponent().getExtendsTypeName());
        this.getMutableImpl().setInstalledComponentTargeter(inDependencyTargeter);
        InstalledTarget theTarget = Dependency.resolveDependency(inDependencyTargeter, ctx, caller, installDBContext);
        this.getMutableImpl().setDependeeInstalledComponentID(theTarget.getInstalledComponent().getID());
        Component dependeeDeclaredComp = theTarget.getCallerForMember(null).getDeclaredComponent();
        this.getMutableImpl().setDependeeDeclaredComponentExtendsTypeName(dependeeDeclaredComp.getExtendsTypeName());
    }

    public static InstalledTarget resolveDependency(InstalledComponentTargeter targeter, TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws InstallDBException {
        InstalledTarget theTarget = null;
        if (targeter.isBulkTargeter()) {
            throw InstallDBException.dependencyCannotUseBulkTargeter(targeter);
        }
        try {
            theTarget = targeter.getInstalledTarget(ctx, caller, installDBContext);
        }
        catch (RaplixException e) {
            throw DependencyViolationException.unableToResolveDependencyTarget(targeter, e);
        }
        return theTarget;
    }

    public void checkDependency(Host targetHost, InstalledComponent expectedTarget, InstallDBContext installDBContext) throws InstallDBException {
        Caller caller = null;
        DependencyCheckTargetedConfigContext ctx = null;
        try {
            InstalledComponent ic = installDBContext.getInstalledComponent(this.getDependantInstalledComponentID());
            Component actual = ic.getComponentID().getByIDQuery().select();
            Component declared = actual.getAncestorByExtendsTypeName(this.getDependantDeclaredComponentExtendsTypeName());
            caller = new Caller(ic, actual, declared);
            ctx = new DependencyCheckTargetedConfigContext(targetHost);
        }
        catch (PersistenceManagerException pme) {
            throw new DependencyViolationException(pme);
        }
        catch (RPCException rpce) {
            throw new DependencyViolationException(rpce);
        }
        InstalledTarget target = Dependency.resolveDependency(this.getImpl().getInstalledComponentTargeter(), ctx, caller, installDBContext);
        if (target.getInstalledComponent() != expectedTarget) {
            throw DependencyViolationException.resolvedDependencyDoesNotMatchExpectedValue(expectedTarget.getID(), target.getInstalledComponent().getID());
        }
    }

    private Dependency() {
        this.setImpl(DependencyImpl.create());
        this.mImplIsCopy = true;
    }

    void setImpl(DependencyImpl impl) {
        this.mImpl = impl;
    }

    public ObjectID getObjectID() {
        return this.getImpl().getObjectID();
    }

    Dependency(DependencyImpl impl) {
        this.mImpl = impl;
        this.mImplIsCopy = false;
    }

    DependencyImpl getImpl() {
        return this.mImpl;
    }

    DependencyImpl getMutableImpl() {
        if (!this.mImplIsCopy) {
            this.setImpl((DependencyImpl)this.getImpl().clone());
            this.mImplIsCopy = true;
        }
        return this.getImpl();
    }

    public DependencyID getID() {
        return (DependencyID)this.getObjectID();
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public InstalledComponentID getDependantInstalledComponentID() {
        return this.getImpl().getDependantInstalledComponentID();
    }

    public String getDependantDeclaredComponentExtendsTypeName() {
        return this.getImpl().getDependantDeclaredComponentExtendsTypeName();
    }

    public InstalledComponentID getDependeeInstalledComponentID() {
        return this.getImpl().getDependeeInstalledComponentID();
    }

    public String getDependeeDeclaredComponentExtendsTypeName() {
        return this.getImpl().getDependeeDeclaredComponentExtendsTypeName();
    }

    public InstalledComponentTargeter getInstalledComponentTargeter() {
        return this.getImpl().getInstalledComponentTargeter();
    }

    void save() throws PersistenceManagerException, RPCException {
        this.getMutableImpl().save();
    }

    public Object clone() {
        if (this.mImplIsCopy) {
            return new Dependency((DependencyImpl)this.getImpl().clone());
        }
        return new Dependency(this.getImpl());
    }

    public String getDescription() {
        return "";
    }

    public Visibility getVisibility() {
        return Visibility.VISIBLE;
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        this.getImpl().addComponentRefsMS(set);
    }
}

