/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverride;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideTable;
import com.raplix.util.regex.GlobPattern;

class VarOverrideSQLOps
extends VarOverrideTable {
    public static final VarOverrideSQLOps DEFAULT = new VarOverrideSQLOps();

    public VarOverrideSQLOps(String alias) {
        super(alias);
    }

    private VarOverrideSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new VarOverrideSQLOps(alias);
    }

    public int removeObsoletes(HostTypeID id, String[] currentVarNames) throws PersistenceManagerException {
        return VarOverrideSQLOps.execute(this.delete(VarOverrideSQLOps.where(VarOverrideSQLOps.and(VarOverrideSQLOps.equals(this.HostTypeID, id), VarOverrideSQLOps.not(VarOverrideSQLOps.emptyIn(this.VarName, VarOverrideSQLOps.rList(currentVarNames)))))));
    }

    public int removeByHost(HostID id) throws PersistenceManagerException {
        return VarOverrideSQLOps.execute(this.delete(VarOverrideSQLOps.where(VarOverrideSQLOps.equals(this.HostID, id))));
    }

    public VarOverride[] getByHosts(HostID[] ids) throws PersistenceManagerException {
        return this.exec(VarOverrideSQLOps.select((SelectList)this.allColumns(), VarOverrideSQLOps.tList(this), VarOverrideSQLOps.where(VarOverrideSQLOps.emptyIn(this.HostID, VarOverrideSQLOps.rList(ids))), VarOverrideSQLOps.oList(VarOverrideSQLOps.orderByAsc(this.HostID)).add(VarOverrideSQLOps.dictOrderAsc(this.VarName))));
    }

    public VarOverride[] getByHost(HostID id) throws PersistenceManagerException {
        return this.exec(VarOverrideSQLOps.select((SelectList)this.allColumns(), VarOverrideSQLOps.tList(this), VarOverrideSQLOps.where(VarOverrideSQLOps.equals(this.HostID, id)), VarOverrideSQLOps.dictOrderAsc(this.VarName)));
    }

    private VarOverride[] exec(Select query) throws PersistenceManagerException {
        return (VarOverride[])VarOverrideSQLOps.executeMultiResult(query, this, VarOverride.class);
    }

    public ConditionalExpression hasVarWithValue(String varName, GlobPattern valuePat, HostImplTable hT) {
        return VarOverrideSQLOps.exists(this.select(VarOverrideSQLOps.sList(this.HostID), VarOverrideSQLOps.where(VarOverrideSQLOps.and(VarOverrideSQLOps.and(VarOverrideSQLOps.equals((ColumnNode)this.HostID, hT.ID), VarOverrideSQLOps.equals(this.VarName, varName)), VarOverrideSQLOps.likeLower(this.OverrideValue, valuePat)))));
    }

    public ConditionalExpression hasVar(String varName, HostImplTable hT) {
        return VarOverrideSQLOps.exists(this.select(VarOverrideSQLOps.sList(this.HostID), VarOverrideSQLOps.where(VarOverrideSQLOps.and(VarOverrideSQLOps.equals((ColumnNode)this.HostID, hT.ID), VarOverrideSQLOps.equals(this.VarName, varName)))));
    }
}

