/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDeclTable;
import com.raplix.util.regex.GlobPattern;

class VarDeclSQLOps
extends VarDeclTable {
    public static final VarDeclSQLOps DEFAULT = new VarDeclSQLOps();

    public VarDeclSQLOps(String alias) {
        super(alias);
    }

    private VarDeclSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new VarDeclSQLOps(alias);
    }

    public VarDecl[] getByHostTypes(HostTypeID[] hostTypeIDs) throws PersistenceManagerException {
        return this.executeMulti(VarDeclSQLOps.select((SelectList)this.allColumns(), VarDeclSQLOps.tList(this), VarDeclSQLOps.where(VarDeclSQLOps.emptyIn(this.HostTypeID, VarDeclSQLOps.rList(hostTypeIDs))), VarDeclSQLOps.oList(VarDeclSQLOps.orderByAsc(this.HostTypeID), VarDeclSQLOps.orderByAsc(this.Order))));
    }

    public Select getNamesByHostTypes(Select hostTypeIDs) throws PersistenceManagerException {
        return VarDeclSQLOps.distinct(VarDeclSQLOps.select(VarDeclSQLOps.sList(this.VarName, (ScalarExp)VarDeclSQLOps.upper(this.VarName)), VarDeclSQLOps.tList(this), VarDeclSQLOps.where(VarDeclSQLOps.in((ColumnNode)this.HostTypeID, hostTypeIDs)), VarDeclSQLOps.dictOrderAsc(this.VarName)));
    }

    public VarDecl[] getByHostType(HostTypeID hostTypeID) throws PersistenceManagerException {
        return this.executeMulti(VarDeclSQLOps.select((SelectList)this.allColumns(), VarDeclSQLOps.tList(this), VarDeclSQLOps.where(VarDeclSQLOps.equals(this.HostTypeID, hostTypeID)), VarDeclSQLOps.oList(VarDeclSQLOps.orderByAsc(this.Order))));
    }

    public VarDecl[] executeMulti(Select query) throws PersistenceManagerException {
        return (VarDecl[])VarDeclSQLOps.executeMultiResult(query, this, VarDecl.class);
    }

    public int removeObsoletes(HostTypeID id, String[] currentVarNames) throws PersistenceManagerException {
        return VarDeclSQLOps.execute(this.delete(VarDeclSQLOps.where(VarDeclSQLOps.and(VarDeclSQLOps.equals(this.HostTypeID, id), VarDeclSQLOps.not(VarDeclSQLOps.emptyIn(this.VarName, VarDeclSQLOps.rList(currentVarNames)))))));
    }

    public int removeByHostType(HostTypeID id) throws PersistenceManagerException {
        return VarDeclSQLOps.execute(this.delete(VarDeclSQLOps.where(VarDeclSQLOps.equals(this.HostTypeID, id))));
    }

    public ConditionalExpression hasVarWithValue(String varName, GlobPattern valuePat, HostImplTable hT) {
        return VarDeclSQLOps.exists(this.select(VarDeclSQLOps.sList(this.HostTypeID), VarDeclSQLOps.where(VarDeclSQLOps.and(VarDeclSQLOps.and(VarDeclSQLOps.equals((ColumnNode)this.HostTypeID, hT.HostTypeID), VarDeclSQLOps.equals(this.VarName, varName)), VarDeclSQLOps.likeLower(this.DefaultValue, valuePat)))));
    }

    public int createUniqueOrders(HostTypeID hostTypeID) throws PersistenceManagerException {
        return VarDeclSQLOps.execute(this.update(VarDeclSQLOps.uList(VarDeclSQLOps.set((ColumnNode)this.Order, VarDeclSQLOps.times(VarDeclSQLOps.v(-1), VarDeclSQLOps.plus(this.Order, VarDeclSQLOps.v(1))))), VarDeclSQLOps.where(VarDeclSQLOps.equals(this.HostTypeID, hostTypeID))));
    }
}

