/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.util.regex.GlobPattern;

public class VarCriteria
extends AttributeCriteria {
    private String mVarName;

    private VarCriteria() {
    }

    public VarCriteria(String varName, ComparisonType compType, GlobPattern valuePattern) {
        this.setVarName(varName);
        this.setComparisonType(compType);
        this.setValuePattern(valuePattern);
    }

    public String getVarName() {
        return this.mVarName;
    }

    public void setVarName(String varName) {
        if (varName == null) {
            throw new NullPointerException();
        }
        this.mVarName = varName;
    }

    public String getAttributeName() {
        return this.getVarName();
    }

    ConditionalExpression getConditional(HostSQLOps hostTable) {
        return hostTable.getByVarValue(this.getVarName(), this.getComparisonValuePattern());
    }

    boolean matches(Host h) {
        String val = h.getVarValue(this.getVarName());
        return val != null && this.matches(val);
    }

    private static class ID
    extends ObjectID {
        private ID() {
        }

        private ID(String id) {
            super(id);
        }
    }

    private static class IDFactory
    extends ObjectIDFactory {
        private IDFactory() {
        }

        public ObjectID newInstance(String id) {
            return new ID(id);
        }
    }
}

