/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;

public class PhysicalCriteria
implements RPCSerializable,
Cloneable {
    private boolean mIncludePhysical = false;
    private boolean mIncludeVirtual = false;
    public static final String OPTION_ENABLED = "t";
    public static final String OPTION_DISABLED = "f";

    public boolean getIncludePhysical() {
        return this.mIncludePhysical;
    }

    public void setIncludePhysical(boolean includePhysical) {
        this.mIncludePhysical = includePhysical;
    }

    public boolean getIncludeVirtual() {
        return this.mIncludeVirtual;
    }

    public void setIncludeVirtual(boolean includeVirtual) {
        this.mIncludeVirtual = includeVirtual;
    }

    ConditionalExpression getConditional(HostSQLOps hostTable) {
        return hostTable.getByPhysical(this);
    }

    boolean matches(Host host) {
        if (this.getIncludePhysical() && !host.isVirtual()) {
            return true;
        }
        return this.getIncludeVirtual() && host.isVirtual();
    }

    public boolean isEmptyCriteria() {
        return !this.getIncludePhysical() && !this.getIncludeVirtual();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer buf) {
        this.appendOption(buf, this.getIncludePhysical());
        buf.append("|");
        this.appendOption(buf, this.getIncludeVirtual());
        return buf;
    }

    private void appendOption(StringBuffer buf, boolean option) {
        if (option) {
            buf.append(OPTION_ENABLED);
        } else {
            buf.append(OPTION_DISABLED);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PhysicalCriteria)) {
            return false;
        }
        PhysicalCriteria otherCriteria = (PhysicalCriteria)other;
        return this.getIncludePhysical() == otherCriteria.getIncludePhysical() && this.getIncludeVirtual() == otherCriteria.getIncludeVirtual();
    }

    public int hashCode() {
        int result = 0;
        if (this.getIncludePhysical()) {
            result |= 1;
        }
        if (this.getIncludeVirtual()) {
            result |= 2;
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void reset() {
        this.setIncludePhysical(false);
        this.setIncludeVirtual(false);
    }
}

