/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.util.regex.GlobPattern;

public class ParentCriteria
extends AttributeCriteria {
    private ParentCriteria() {
    }

    public ParentCriteria(ComparisonType compType, GlobPattern valuePattern) {
        super(compType, valuePattern);
    }

    public String getAttributeName() {
        return "sys.parent";
    }

    ConditionalExpression getConditional(HostSQLOps hostTable) {
        return hostTable.getByParentHostName(this.getComparisonValuePattern());
    }

    boolean matches(Host h) {
        HostID parentID = h.getParentHostID();
        if (parentID == null) {
            return false;
        }
        try {
            SummaryHost parent = parentID.getByIDQuery().selectSummaryView();
            return this.matches(parent.getName());
        }
        catch (PersistenceManagerException e) {
        }
        catch (RPCException rPCException) {
            // empty catch block
        }
        return false;
    }

    private static class ID
    extends ObjectID {
        private ID() {
        }

        private ID(String id) {
            super(id);
        }
    }

    private static class IDFactory
    extends ObjectIDFactory {
        private IDFactory() {
        }

        public ObjectID newInstance(String id) {
            return new ID(id);
        }
    }
}

