/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.CompleteHostTypeProcessor;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostTypeProcessor;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDeclSQLOps;

public class MultiHostTypeQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final HostTypeSQLOps TABLE = new HostTypeSQLOps("typeT");

    public static MultiHostTypeQuery all() {
        MultiHostTypeQuery result = new MultiHostTypeQuery((ConditionalExpression)null);
        result.setObjectOrder(HostTypeOrder.BY_NAME_ASC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    static MultiHostTypeQuery byIDs(HostTypeID[] IDs) {
        return new MultiHostTypeQuery(IDs);
    }

    private MultiHostTypeQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, HostTypeOrder.FACTORY);
    }

    private MultiHostTypeQuery(HostTypeID[] IDs) {
        super((Table)TABLE, IDs, HostTypeOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((HostTypeOrder)order);
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public HostType[] select() throws RPCException, PersistenceManagerException {
        CompleteHostTypeProcessor processor = new CompleteHostTypeProcessor(this.getTable(), false);
        return (HostType[])this.select(processor, HostType.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public SummaryHostType[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryHostTypeProcessor processor = new SummaryHostTypeProcessor(this.getTable(), false);
        return (SummaryHostType[])this.select(processor, SummaryHostType.class);
    }

    public String[] selectVarNames() throws RPCException, PersistenceManagerException {
        HostTypeSQLOps t = (HostTypeSQLOps)this.getTable();
        Select hostIDQuery = t.selectIDs(this.getWhereClause());
        Select varNameQuery = VarDeclSQLOps.DEFAULT.getNamesByHostTypes(hostIDQuery);
        return this.selectStringArrayResult(varNameQuery);
    }
}

