/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.CompleteHostSetProcessor;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSetProcessor;

public class MultiHostSetQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final HostSetSQLOps TABLE = new HostSetSQLOps("setT");
    private Boolean mIsSupportedFilter;

    public static MultiHostSetQuery all() {
        MultiHostSetQuery result = new MultiHostSetQuery((ConditionalExpression)null);
        result.setObjectOrder(HostSetOrder.BY_NAME_ASC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    static MultiHostSetQuery byIDs(HostSetID[] IDs) {
        return new MultiHostSetQuery(IDs);
    }

    private MultiHostSetQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, HostSetOrder.FACTORY);
    }

    private MultiHostSetQuery(HostSetID[] IDs) {
        super((Table)TABLE, IDs, HostSetOrder.FACTORY);
    }

    public Boolean getIsSupportedFilter() {
        return this.mIsSupportedFilter;
    }

    public void setIsSupportedFilter(Boolean inIsSupported) {
        this.mIsSupportedFilter = inIsSupported;
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((HostSetOrder)order);
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public HostSet[] select() throws RPCException, PersistenceManagerException {
        CompleteHostSetProcessor processor = new CompleteHostSetProcessor(this.getTable(), false);
        return (HostSet[])this.select(processor, HostSet.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public SummaryHostSet[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryHostSetProcessor processor = new SummaryHostSetProcessor(this.getTable(), false);
        return (SummaryHostSet[])this.select(processor, SummaryHostSet.class);
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        HostSetSQLOps t = (HostSetSQLOps)this.getTable();
        if (this.getIsSupportedFilter() != null) {
            ConditionalExpression filter = t.isSupported(true);
            filter = t.isSupported(this.getIsSupportedFilter());
            ctx.addAndWhereCondition(filter);
        }
    }
}

