/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.CompleteHostProcessor;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostProcessor;

public class MultiHostQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final HostSQLOps TABLE = new HostSQLOps("hostT");
    private AppType[] mAppTypeFilter;
    private HostTypeID mHostTypeFilter;
    private HostSetID mHostSetFilter;
    private boolean mExcludeSentinelHost = true;

    public static MultiHostQuery all() {
        MultiHostQuery result = new MultiHostQuery((ConditionalExpression)null);
        result.setObjectOrder(HostOrder.BY_APP_TYPE_ASC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    static MultiHostQuery byType(HostTypeID ID2) {
        return new MultiHostQuery(TABLE.isType(ID2));
    }

    static MultiHostQuery byIDs(HostIDSet idSet) {
        return new MultiHostQuery(idSet);
    }

    static MultiHostQuery byCriteria(HostSearchCriteria criteria) {
        MultiHostQuery result = new MultiHostQuery(criteria.getConditional(TABLE));
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    static MultiHostQuery bySearch(HostSearchID searchID) throws RPCException, PersistenceManagerException {
        ConditionalExpression cond = null;
        try {
            HostSearch search = searchID.getByIDQuery().select();
            cond = search.getCriteria().getConditional(TABLE);
        }
        catch (NoResultsFoundException e) {
            cond = TABLE.none();
        }
        MultiHostQuery result = new MultiHostQuery(cond);
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    static MultiHostQuery byMembers(HostSetImpl hs) throws PersistenceManagerException, RPCException {
        MultiHostQuery result = new MultiHostQuery(TABLE.isMemberOf(hs));
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    static MultiHostQuery byExclusiveMembersOf(HostSetID inSet, HostSetID notInSet) throws PersistenceManagerException, RPCException {
        return new MultiHostQuery(TABLE.isExclusiveMemberOf(inSet, notInSet));
    }

    static MultiHostQuery byHostSet(HostSetID hostSetID) throws PersistenceManagerException, RPCException {
        MultiHostQuery result = new MultiHostQuery(TABLE.isMemberOf(hostSetID));
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    static MultiHostQuery byParentID(HostID parentID) {
        MultiHostQuery result = new MultiHostQuery(TABLE.isChildOf(parentID));
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    static MultiHostQuery byAppParent(HostID inParentID) {
        MultiHostQuery result = new MultiHostQuery(HostSQLOps.in((ColumnNode)MultiHostQuery.TABLE.ID, AppInstanceSQLOps.DEFAULT.getAppChildren(inParentID)));
        result.setObjectOrder(HostOrder.BY_NAME_ASC);
        return result;
    }

    private MultiHostQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, HostOrder.FACTORY);
    }

    private MultiHostQuery(HostIDSet idSet) {
        super((Table)TABLE, idSet.toIDArray(), HostOrder.FACTORY);
        this.setExcludeSentinelHost(idSet.contains(Host.HOST_SENTINEL_ID));
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((HostOrder)order);
    }

    public AppType[] getAppTypeFilter() {
        return this.mAppTypeFilter == null ? null : (AppType[])this.mAppTypeFilter.clone();
    }

    public void setAppTypeFilter(AppType[] appTypeFilter) {
        if (appTypeFilter != null) {
            appTypeFilter = (AppType[])appTypeFilter.clone();
        }
        this.mAppTypeFilter = appTypeFilter;
    }

    public HostTypeID getHostTypeFilter() {
        return this.mHostTypeFilter;
    }

    public void setHostTypeFilter(HostTypeID hostTypeFilter) {
        this.mHostTypeFilter = hostTypeFilter;
    }

    public HostSetID getHostSetFilter() {
        return this.mHostSetFilter;
    }

    public void setHostSetFilter(HostSetID hostSetFilter) {
        this.mHostSetFilter = hostSetFilter;
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    private boolean getExcludeSentinelHost() {
        return this.mExcludeSentinelHost;
    }

    private void setExcludeSentinelHost(boolean exclude) {
        this.mExcludeSentinelHost = exclude;
    }

    public Host[] select() throws RPCException, PersistenceManagerException {
        CompleteHostProcessor processor = new CompleteHostProcessor(this.getTable(), false);
        return (Host[])this.select(processor, Host.class);
    }

    public SummaryHost[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryHostProcessor processor = new SummaryHostProcessor(this.getTable(), false);
        return (SummaryHost[])this.select(processor, SummaryHost.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        HostSQLOps t = (HostSQLOps)this.getTable();
        if (this.getHostTypeFilter() != null) {
            ctx.addAndWhereCondition(t.equalsHostType(this.getHostTypeFilter()));
        }
        if (this.getAppTypeFilter() != null) {
            ctx.addAndWhereCondition(t.containsAppType(this.getAppTypeFilter()));
        }
        if (this.getHostSetFilter() != null) {
            ctx.addAndWhereCondition(t.isMemberOf(this.getHostSetFilter()));
        }
        if (this.getExcludeSentinelHost()) {
            ctx.addAndWhereCondition(HostSQLOps.not(HostSQLOps.equals(t.ID, Host.HOST_SENTINEL_ID)));
        }
    }
}

