/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.CompleteAppInstanceProcessor;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class MultiAppInstanceQuery
extends MultiObjectQueryImpl {
    private static final AppInstanceSQLOps TABLE = new AppInstanceSQLOps("appT");

    public static MultiAppInstanceQuery all() {
        return new MultiAppInstanceQuery((ConditionalExpression)null);
    }

    static MultiAppInstanceQuery byIDs(AppInstanceID[] IDs) {
        return new MultiAppInstanceQuery(IDs);
    }

    static MultiAppInstanceQuery byHosts(HostID[] hostIDs) {
        MultiAppInstanceQuery result = new MultiAppInstanceQuery(TABLE.isInHosts(hostIDs));
        result.setObjectOrder(AppInstanceOrder.BY_HOST_ID_ASC);
        return result;
    }

    static MultiAppInstanceQuery byHost(HostID hostID) {
        return new MultiAppInstanceQuery(TABLE.isInHost(hostID));
    }

    static MultiAppInstanceQuery byIPNotHost(HostID hostID, String ip) {
        return new MultiAppInstanceQuery(TABLE.isIPNotHost(hostID, ip));
    }

    static MultiAppInstanceQuery byDuplicateIP() {
        return new MultiAppInstanceQuery(TABLE.isDuplicateIP());
    }

    private MultiAppInstanceQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, AppInstanceOrder.FACTORY);
    }

    private MultiAppInstanceQuery(AppInstanceID[] IDs) {
        super((Table)TABLE, IDs, AppInstanceOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((AppInstanceOrder)order);
    }

    public AppInstance[] select() throws RPCException, PersistenceManagerException {
        CompleteAppInstanceProcessor processor = new CompleteAppInstanceProcessor(this.getTable(), false);
        return (AppInstance[])this.select(processor, AppInstance.class);
    }
}

