/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBIllegalArgError;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.util.collections.TypedList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class HostTypeVarList
extends TypedList
implements VariableSettingsSource {
    private Hashtable mVarMap = new Hashtable();
    private static final HostTypeVar[] EMPTY_ARR = new HostTypeVar[0];

    public HostTypeVarList() {
    }

    public HostTypeVarList(Collection c) {
        this.addAll(c);
    }

    public HostTypeVar getVar(int index) {
        return (HostTypeVar)this.get(index);
    }

    public boolean containsVarValue(String varName) {
        if (varName == null) {
            return false;
        }
        return this.mVarMap.containsKey(varName);
    }

    public String getVarValue(String varName) {
        if (varName == null) {
            return null;
        }
        HostTypeVar var = (HostTypeVar)this.mVarMap.get(varName);
        if (var == null) {
            return null;
        }
        return var.getDefaultValue();
    }

    public String[] getVarNames() {
        int size = this.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.getVar(i).getName();
        }
        return result;
    }

    public void add(int index, Object element) {
        HostTypeVar var = (HostTypeVar)element;
        String name = var.getName();
        if (this.containsVarValue(name)) {
            throw HostDBIllegalArgError.duplicateVarName(name);
        }
        super.add(index, element);
        this.mVarMap.put(name, element);
    }

    public Object set(int index, Object element) {
        HostTypeVar var = (HostTypeVar)element;
        String name = var.getName();
        String curName = this.getVar(index).getName();
        if (!curName.equals(name) && this.containsVarValue(name)) {
            throw HostDBIllegalArgError.duplicateVarName(name);
        }
        Object result = super.set(index, element);
        this.mVarMap.remove(curName);
        this.mVarMap.put(name, element);
        return result;
    }

    public void swap(int n1, int n2) {
        super.set(n1, super.set(n2, this.get(n1)));
    }

    public boolean addAll(int index, Collection c) {
        Hashtable<String, HostTypeVar> locals = new Hashtable<String, HostTypeVar>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            HostTypeVar var = (HostTypeVar)it.next();
            String name = var.getName();
            if (this.containsVarValue(name)) {
                throw HostDBIllegalArgError.duplicateVarName(name);
            }
            if (locals.put(name, var) == null) continue;
            throw HostDBIllegalArgError.duplicateVarName(name);
        }
        boolean result = super.addAll(index, c);
        this.mVarMap.putAll(locals);
        return result;
    }

    public Object remove(int index) {
        HostTypeVar var = (HostTypeVar)super.remove(index);
        this.mVarMap.remove(var.getName());
        return var;
    }

    public Object[] toArray() {
        return this.toVarArray();
    }

    public HostTypeVar[] toVarArray() {
        return this.toVarArray(EMPTY_ARR);
    }

    public HostTypeVar[] toVarArray(HostTypeVar[] arr) {
        return (HostTypeVar[])super.toArray(arr);
    }

    protected void checkElement(Object obj) {
        HostTypeVar v = (HostTypeVar)obj;
        if (v == null) {
            throw new NullPointerException();
        }
    }

    public Object clone() {
        HostTypeVarList result = (HostTypeVarList)super.clone();
        result.mVarMap = new Hashtable();
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            HostTypeVar var = result.getVar(i);
            result.set(i, var.clone());
        }
        return result;
    }

    public void validate() throws HostDBException {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            HostTypeVar var = (HostTypeVar)it.next();
            var.validate();
        }
    }
}

