/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.util.Validate;

public class HostTypeVar
implements Cloneable,
RPCSerializable {
    private String mName;
    private String mDefaultValue;
    private static final int MAX_NAME_LEN = 512;

    public HostTypeVar(String varName, String defaultValue) {
        this.setName(varName);
        this.setDefaultValue(defaultValue);
    }

    private HostTypeVar() {
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException();
        }
        this.mDefaultValue = defaultValue;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HostTypeVar)) {
            return false;
        }
        HostTypeVar otherVar = (HostTypeVar)other;
        return otherVar.getName().equals(this.getName()) && otherVar.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getDefaultValue().hashCode();
    }

    public void validate() throws HostDBException {
        HostTypeVar.validateName(this.getName());
        HostTypeVar.validateDefaultValue(this.getDefaultValue());
    }

    public static void validateName(String name) throws HostDBException {
        if (name == null) {
            throw HostDBException.invalidVarName(name);
        }
        int len = name.length();
        if (len < 1 || len > 512) {
            throw HostDBException.invalidVarName(name);
        }
        if (!HostTypeVar.isValidNameStart(name.charAt(0))) {
            throw HostDBException.invalidVarName(name);
        }
        for (int i = 1; i < len; ++i) {
            if (HostTypeVar.isValidNameChar(name.charAt(i))) continue;
            throw HostDBException.invalidVarName(name);
        }
    }

    private static boolean isValidNameStart(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    private static boolean isValidNameChar(char ch) {
        return HostTypeVar.isValidNameStart(ch) || Character.isDigit(ch);
    }

    public static void validateDefaultValue(String defaultValue) throws HostDBException {
        if (!Validate.isValidObjectDescription(defaultValue)) {
            throw HostDBException.invalidVarDefaultValue(defaultValue);
        }
    }
}

