/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.regex.GlobPattern;

class HostTypeSQLOps
extends HostTypeImplTable {
    public static final HostTypeSQLOps DEFAULT = new HostTypeSQLOps();

    public HostTypeSQLOps(String alias) {
        super(alias);
    }

    private HostTypeSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new HostTypeSQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return HostTypeSQLOps.equals(this.Name, name);
    }

    private OrderByList orderByDefaultFirst(QueryContext ctx) throws RPCException, PersistenceManagerException {
        return HostTypeSQLOps.oList(HostTypeSQLOps.orderByDesc(HostTypeSQLOps.equals(this.ID, SystemPluginConstants.getInstance().DEFAULT_HOST_TYPE_ID)));
    }

    public OrderByList orderByNameAsc(QueryContext ctx) throws RPCException, PersistenceManagerException {
        return this.orderByDefaultFirst(ctx).add(HostTypeSQLOps.dictOrderAsc(this.Name));
    }

    public OrderByList orderByNameDesc(QueryContext ctx) throws RPCException, PersistenceManagerException {
        return this.orderByDefaultFirst(ctx).add(HostTypeSQLOps.dictOrderDesc(this.Name));
    }

    public Select selectIDs(WhereClause whereClause) {
        return HostTypeSQLOps.select(HostTypeSQLOps.sList(this.ID), HostTypeSQLOps.tList(this), whereClause);
    }

    public ConditionalExpression hasTypeWithName(GlobPattern namePat, HostImplTable hT) {
        return HostTypeSQLOps.exists(this.select(HostTypeSQLOps.sList(this.ID), HostTypeSQLOps.where(HostTypeSQLOps.and(HostTypeSQLOps.equals((ColumnNode)this.ID, hT.HostTypeID), HostTypeSQLOps.likeLower(this.Name, namePat)))));
    }
}

