/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDeclSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideSQLOps;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

class HostTypeImpl
extends PersistentBean
implements Cloneable {
    private String mSimpleName;
    private String mPluginName;
    private String mDescription = "";
    private PluginID mPluginID;
    private transient SummaryHostType mSummaryView;
    private Hashtable mVarDeclMap;
    private HostTypeVarList mVarList = null;
    private static final String VAR_DECL_SAVE_NAME = "VarDeclMap";

    private HostTypeImpl() {
    }

    static HostTypeImpl create() {
        HostTypeImpl result = new HostTypeImpl();
        result.resetVarDecls();
        return result;
    }

    static HostTypeImpl create(PluginID pluginID) throws PersistenceManagerException, RPCException {
        HostTypeImpl result = HostTypeImpl.create();
        result.setPluginID(pluginID);
        result.setPluginName(pluginID.getByIDQuery().selectSummaryView().getName());
        return result;
    }

    HostTypeID getID() {
        return (HostTypeID)this.getObjectID();
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    String getName() {
        if (this.getPluginID() != null) {
            return this.getPluginName() + Plugin.NAME_SEPARATOR + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        int separatorIndex = name.indexOf(Plugin.NAME_SEPARATOR);
        if (separatorIndex != -1) {
            this.setPluginName(name.substring(0, separatorIndex));
            this.setSimpleName(name.substring(separatorIndex + 1));
        } else {
            this.setSimpleName(name);
        }
    }

    String getSimpleName() {
        return this.mSimpleName;
    }

    void setSimpleName(String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.mSimpleName = simpleName;
    }

    private void setPluginName(String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException();
        }
        this.mPluginName = pluginName;
    }

    private String getPluginName() {
        return this.mPluginName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException();
        }
        this.mDescription = description;
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }

    SummaryHostType getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryHostType(this);
        }
        return this.mSummaryView;
    }

    HostType getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new HostType(this);
    }

    private void resetVarDecls() {
        this.mVarDeclMap = new Hashtable();
        this.mVarList = new HostTypeVarList();
    }

    private boolean varDeclsNotLoaded() {
        return this.mVarDeclMap == null;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.varDeclsNotLoaded()) {
            if (this.getID() != null) {
                this.addVarDecls(VarDeclSQLOps.DEFAULT.getByHostType(this.getID()), 0);
            } else {
                this.resetVarDecls();
            }
        }
    }

    private synchronized int addVarDecls(VarDecl[] varDecls, int startNdx) throws PersistenceManagerException {
        int i;
        boolean addDecls = this.varDeclsNotLoaded();
        Hashtable<String, SaveResult> varDeclMap = null;
        HostTypeVarList varList = null;
        if (addDecls) {
            varDeclMap = new Hashtable<String, SaveResult>();
            varList = new HostTypeVarList();
        }
        for (i = startNdx; i < varDecls.length && varDecls[i].getHostTypeID().equals(this.getID()); ++i) {
            if (!addDecls) continue;
            varDeclMap.put(varDecls[i].getVarName(), varDecls[i].createSaveResult());
            varList.add(varDecls[i].toHostTypeVar());
        }
        if (addDecls) {
            this.mVarList = varList;
            this.mVarDeclMap = varDeclMap;
        }
        return i;
    }

    static void loadExternalDataMS(Vector hostTypes) throws PersistenceManagerException {
        HostTypeID id;
        int size = hostTypes.size();
        if (size == 0) {
            return;
        }
        HashMap<HostTypeID, HostTypeImpl> map = new HashMap<HostTypeID, HostTypeImpl>();
        HostTypeIDSet idSet = new HostTypeIDSet();
        for (int i = 0; i < size; ++i) {
            HostTypeImpl hostType = (HostTypeImpl)hostTypes.get(i);
            if (!hostType.varDeclsNotLoaded()) continue;
            id = hostType.getID();
            map.put(id, hostType);
            idSet.add(id);
        }
        if (idSet.isEmpty()) {
            return;
        }
        VarDecl[] vd = VarDeclSQLOps.DEFAULT.getByHostTypes(idSet.toIDArray());
        int i = 0;
        while (i < vd.length) {
            id = vd[i].getHostTypeID();
            HostTypeImpl ht = (HostTypeImpl)map.get(id);
            i = ht.addVarDecls(vd, i);
        }
    }

    HostTypeVarList getVarList() {
        return (HostTypeVarList)this.mVarList.clone();
    }

    void setVarList(HostTypeVarList varList) {
        this.mVarList = (HostTypeVarList)varList.clone();
    }

    String[] getVarNames() {
        return this.mVarList.getVarNames();
    }

    String getVarValue(String varName) {
        return this.mVarList.getVarValue(varName);
    }

    boolean containsVarValue(String varName) {
        return this.mVarList.containsVarValue(varName);
    }

    void save(boolean removeHostOverrides) throws HostDBException, PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(new SaveContext(removeHostOverrides));
    }

    void validate() throws HostDBException {
        HostType.validateSimpleName(this.getSimpleName());
        HostType.validateDescription(this.getDescription());
        this.mVarList.validate();
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        final boolean removeHostOverrides = ((SaveContext)context).mRemoveHostOverrides;
        HostTypeImpl.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostTypeImpl.this.trSaveMS(removeHostOverrides);
                return null;
            }
        });
    }

    private void trSaveMS(boolean removeHostOverrides) throws PersistenceManagerException {
        Plugin.checkWritePermissions(this.getSummaryView());
        HostTypeID ID2 = this.getID();
        if (ID2 != null) {
            ID2.lockForUpdateMS();
            HostSQLOps.DEFAULT.incrUpdateCountsByHostType(ID2);
            String[] varNames = this.getVarNames();
            if (removeHostOverrides) {
                VarOverrideSQLOps.DEFAULT.removeObsoletes(ID2, varNames);
            }
            VarDeclSQLOps.DEFAULT.removeObsoletes(ID2, varNames);
            VarDeclSQLOps.DEFAULT.createUniqueOrders(ID2);
            this.mVarDeclMap = this.saveVarDeclsMS(ID2);
            super.saveMS(null);
        } else {
            super.saveMS(null);
            this.mVarDeclMap = this.saveVarDeclsMS(this.getID());
        }
    }

    private Hashtable saveVarDeclsMS(HostTypeID hostTypeID) throws PersistenceManagerException {
        HostTypeVarList varList = this.mVarList;
        int size = varList.size();
        Hashtable<String, SaveResult> newVarDeclMap = new Hashtable<String, SaveResult>();
        for (int i = 0; i < size; ++i) {
            HostTypeVar var = varList.getVar(i);
            SaveResult saveResult = (SaveResult)this.mVarDeclMap.get(var.getName());
            VarDecl decl = new VarDecl(saveResult, hostTypeID, var, i);
            decl.saveMS();
            newVarDeclMap.put(decl.getVarName(), decl.createSaveResult());
        }
        return newVarDeclMap;
    }

    protected SaveResult createSaveResult() throws PersistenceManagerException {
        SaveResult result = super.createSaveResult();
        result.setObjectAssociationResult(VAR_DECL_SAVE_NAME, this.mVarDeclMap);
        return result;
    }

    protected void setSaveResult(SaveResult result) throws PersistenceManagerException {
        super.setSaveResult(result);
        this.mVarDeclMap = (Hashtable)result.getObjectAssociationResult(VAR_DECL_SAVE_NAME);
    }

    protected Object clone() {
        try {
            HostTypeImpl result = (HostTypeImpl)super.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            HostTypeImpl result = (HostTypeImpl)super.getObjectDataClone();
            result.mVarDeclMap = new Hashtable();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private static class SaveContext
    extends PersistContext {
        boolean mRemoveHostOverrides;

        private SaveContext() {
        }

        public SaveContext(boolean removeHostOverrides) {
            this.mRemoveHostOverrides = removeHostOverrides;
        }
    }
}

