/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarDeclSQLOps;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.security.AccessControlException;

public class HostTypeID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    private HostTypeID() {
    }

    public HostTypeID(String key) {
        super(key);
    }

    public SingleHostTypeQuery getByIDQuery() {
        return new SingleHostTypeQuery(this);
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        HostTypeID.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                HostTypeID.this.trDeleteMS();
                return null;
            }
        });
    }

    private void trDeleteMS() throws PersistenceManagerException {
        this.lockForUpdateMS();
        VarDeclSQLOps.DEFAULT.removeByHostType(this);
        super.deleteMS(null);
    }

    public MultiHostQuery getHostsByTypeQuery() {
        return MultiHostQuery.byType(this);
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public static HostTypeID generateID() {
        return (HostTypeID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            final SummaryHostType theHostType = this.getByIDQuery().selectSummaryView();
            try {
                Plugin.checkWritePermissions(theHostType);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{theHostType.getPluginID().getByIDQuery().selectSummaryView()});
            }
            UsingObject[] hosts = MultiHostQuery.byType(this).selectSummaryView();
            if (hosts.length > 0) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), hosts);
            }
            MultiComponentQuery mcq = MultiComponentQuery.all();
            mcq.setVisibilityFilter(null);
            mcq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    ComponentImplTable t = (ComponentImplTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(ComponentImplTable.equals(t.HostType, theHostType.getName()));
                }
            });
            SummaryComponent[] comps = mcq.selectSummaryView();
            for (int i = 0; i < comps.length; ++i) {
                if (inContext.objectWillBeDeletedPriorTo(comps[i].getID(), this)) continue;
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new SummaryComponent[]{comps[i]});
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        HostTypeIDSet idset = new HostTypeIDSet();
        idset.add(this);
        return idset;
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new HostTypeID(inID);
        }
    }
}

