/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.hostdbx;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeImpl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.Validate;

public class HostType
extends SummaryHostType
implements VariableSettingsSource,
Cloneable {
    private boolean mHostTypeIsCopy;

    public HostType() {
        super(HostTypeImpl.create());
        this.mHostTypeIsCopy = true;
    }

    public HostType(PluginID inPluginID) throws PersistenceManagerException, RPCException {
        super(HostTypeImpl.create(inPluginID));
        this.mHostTypeIsCopy = true;
    }

    HostType(HostTypeImpl hostType) {
        super(hostType);
        this.mHostTypeIsCopy = false;
    }

    private HostTypeImpl getMutableHostType() {
        if (!this.mHostTypeIsCopy) {
            this.setHostType((HostTypeImpl)this.getHostType().clone());
            this.mHostTypeIsCopy = true;
        }
        return this.getHostType();
    }

    public void setSimpleName(String name) {
        this.getMutableHostType().setSimpleName(name);
    }

    public void setDescription(String desc) {
        this.getMutableHostType().setDescription(desc);
    }

    public void setVisibility(Visibility visibility) {
        this.getMutableHostType().setVisibility(visibility);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableHostType().setUpdateCount(updateCount);
    }

    public String[] getVarNames() {
        return this.getHostType().getVarNames();
    }

    public String getVarValue(String varName) {
        return this.getHostType().getVarValue(varName);
    }

    public boolean containsVarValue(String varName) {
        return this.getHostType().containsVarValue(varName);
    }

    public HostTypeVarList getVarList() {
        return this.getHostType().getVarList();
    }

    public void setVarList(HostTypeVarList varList) {
        this.getMutableHostType().setVarList(varList);
    }

    public HostType getDataClone() {
        return new HostType((HostTypeImpl)this.getHostType().getObjectDataClone());
    }

    public Object clone() {
        if (this.mHostTypeIsCopy) {
            return new HostType((HostTypeImpl)this.getHostType().clone());
        }
        return new HostType(this.getHostType());
    }

    public void save(boolean removeHostOverrides) throws HostDBException, PersistenceManagerException, RPCException {
        this.getMutableHostType().save(removeHostOverrides);
    }

    public void validate() throws HostDBException {
        this.getHostType().validate();
    }

    public static void validateSimpleName(String name) throws HostDBException {
        if (!Validate.isValidObjectName(name, 32)) {
            throw HostDBException.invalidHostTypeName(name);
        }
    }

    public static void validateDescription(String desc) throws HostDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw HostDBException.invalidHostTypeDescription(desc);
        }
    }
}

